/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.wlbl.utils.MessageUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalance1008Impl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        JSONObject body = MessageUtils.getReqBody();
        body.put("accountNo", (Object)((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo());
        body.put("currencyType", (Object)bankBalanceRequest.getBankCurrency());
        return MessageUtils.sendToBank(bankBalanceRequest.getHeader(), this.getBizCode(), body);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        BalanceInfo balanceInfo = new BalanceInfo();
        JSONObject body = MessageUtils.receive(s);
        String currencyType = body.getString("currencyType");
        String balance = body.getString("balance");
        String accountNo = body.getString("accountNo");
        String avlBalance = body.getString("avlBalance");
        this.setBankAcnt(balanceInfo, (BankAcnt)bankBalanceRequest.getBankAcntList().get(0));
        this.setBalanceDate(balanceInfo, LocalDate.now());
        this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currencyType);
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, avlBalance);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "1008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"TodayBalance1008Impl_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        MessageUtils.setRequestProperty(factory);
    }
}

