/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.services.pay.qynzz;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.wlbl.services.pay.query.QueryPay1013Impl;
import kd.ebg.aqap.banks.cmb.wlbl.utils.MessageUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Pay2007Impl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public void configFactory(ConnectionFactory factory) {
        MessageUtils.setRequestProperty(factory);
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPay1013Impl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = MessageUtils.getReqBody();
        body.put("payAccount", (Object)paymentInfo.getAccNo());
        body.put("payAccountCurrency", (Object)paymentInfo.getPayCurrency());
        body.put("recAccount", (Object)paymentInfo.getIncomeAccNo());
        body.put("transferAmt", (Object)paymentInfo.getAmount().toPlainString());
        body.put("transferCurrency", (Object)paymentInfo.getPayCurrency());
        body.put("payRem", (Object)MessageUtils.checkRem(paymentInfo.getExplanation(), 50));
        body.put("payUse", (Object)"");
        return MessageUtils.sendToBankForPay(bankPayRequest.getHeader(), this.getBizCode(), body, paymentInfo.getBankBatchSeqID());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        JSONObject body = MessageUtils.receive(s);
        String orderFlowNo = body.getString("orderFlowNo");
        if (StringUtils.isEmpty((String)orderFlowNo)) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4ea4\u6613\u6d41\u6c34\u53f7\u3002", (String)"Pay2007Impl_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), (String)"", (String)"");
        } else {
            ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).setBankRefID(orderFlowNo);
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "2007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u5185\u8f6c\u8d26", (String)"Pay2007Impl_1", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String qynzz = PropertiesConstants.getValue((String)"QYNZZ");
        return "2007".equalsIgnoreCase(paymentInfo.getUseCN()) || qynzz.equalsIgnoreCase(paymentInfo.getUseCN());
    }
}

