/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.services.pay.tt;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.wlbl.utils.MessageUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Pay2012Impl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public void configFactory(ConnectionFactory factory) {
        MessageUtils.setRequestProperty(factory);
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return null;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfo.is2SameBank()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u884c\u94f6\u884c\u4e0d\u80fd\u4e3a\u6c38\u9686\u94f6\u884c\u3002", (String)"Pay2012Impl_2", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]));
        }
        JSONObject body = MessageUtils.getReqBody();
        String feeType = paymentInfo.getPayerFeeType();
        if ("01".equalsIgnoreCase(feeType)) {
            body.put("chargeType", (Object)"SHA");
            body.put("serviceChargeAccount", (Object)paymentInfo.getPayerFeeAccNo());
            body.put("serviceChargeCcy", (Object)paymentInfo.getPayerFeeCurrency());
        } else if ("02".equalsIgnoreCase(feeType)) {
            body.put("chargeType", (Object)"BEN");
            body.put("serviceChargeAccount", (Object)paymentInfo.getAccNo());
            body.put("serviceChargeCcy", (Object)paymentInfo.getPayerFeeCurrency());
        } else {
            body.put("chargeType", (Object)"OUR");
            body.put("serviceChargeAccount", (Object)paymentInfo.getPayerFeeAccNo());
            body.put("serviceChargeCcy", (Object)paymentInfo.getPayerFeeCurrency());
        }
        body.put("payAccount", (Object)paymentInfo.getAccNo());
        body.put("payAccountCurrency", (Object)paymentInfo.getPayCurrency());
        body.put("debitMoney", (Object)"");
        body.put("transferAmt", (Object)"");
        if ("EUR".equalsIgnoreCase(bankPayRequest.getAcnt().getCurrency()) && "GBP".equalsIgnoreCase(paymentInfo.getPayCurrency())) {
            body.put("debitMoney", (Object)paymentInfo.getAmount().toPlainString());
        } else {
            body.put("transferAmt", (Object)paymentInfo.getAmount().toPlainString());
        }
        body.put("transferCurrency", (Object)paymentInfo.getPayCurrency());
        CountryISOCode incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (incomeIsoCode == null) {
            incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        body.put("crossBor", (Object)"");
        body.put("cnyCategory", (Object)"");
        if ("CN".equalsIgnoreCase(incomeIsoCode.geteChart2()) && "CNY".equalsIgnoreCase(paymentInfo.getPayCurrency())) {
            body.put("crossBor", (Object)"Y");
            body.put("cnyCategory", (Object)MessageUtils.convert2Purpose(paymentInfo, this.getBizCode()));
        }
        body.put("transitBankCodeType", (Object)"");
        body.put("transitBankCodeField", (Object)"");
        body.put("transitBankCityName", (Object)"");
        body.put("transitOtherBankName", (Object)"");
        body.put("transitBankAddr", (Object)"");
        body.put("transitCountry", (Object)"");
        body.put("toBankCityName", (Object)paymentInfo.getIncomeCity());
        body.put("toOtherBankName", (Object)"");
        body.put("toBankAddr", (Object)"");
        body.put("toCountry", (Object)incomeIsoCode.geteChart2());
        if ("HK".equalsIgnoreCase(incomeIsoCode.geteChart2())) {
            body.put("toBankCodeField", (Object)paymentInfo.getPayeeBankCode());
            body.put("toBankCodeType", (Object)"HK");
        } else if ("CN".equalsIgnoreCase(incomeIsoCode.geteChart2())) {
            body.put("toBankCodeField", (Object)paymentInfo.getIncomeCnaps());
            body.put("toBankCodeType", (Object)"CN");
            body.put("toOtherBankName", (Object)paymentInfo.getIncomeBankName());
        } else {
            body.put("toBankCodeField", (Object)paymentInfo.getIncomeSwiftCode());
            body.put("toBankCodeType", (Object)"SWIFT BIC");
            body.put("toBankCityName", (Object)"");
        }
        body.put("toTransitBankNum", (Object)"");
        body.put("recAccount", (Object)paymentInfo.getIncomeAccNo());
        body.put("recAccountName", (Object)paymentInfo.getIncomeAccName());
        body.put("beneAddr", (Object)"");
        body.put("toAcctCountry", (Object)"");
        body.put("paymentDetail", (Object)MessageUtils.checkRem2(paymentInfo.getExplanation(), 140));
        body.put("mobileNo", (Object)paymentInfo.getApplyPhone());
        body.put("regInd", (Object)"N");
        return MessageUtils.sendToBankForPay(bankPayRequest.getHeader(), this.getBizCode(), body, paymentInfo.getBankBatchSeqID());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        JSONObject body = MessageUtils.receive(s);
        String orderFlowNo = body.getString("orderFlowNo");
        String exchangeRate = body.getString("exchangeRate");
        if (StringUtils.isEmpty((String)orderFlowNo)) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4ea4\u6613\u6d41\u6c34\u53f7\u3002", (String)"Pay2012Impl_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), (String)"", (String)"");
        } else {
            ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).setBankRefID(orderFlowNo);
            ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).setExchangeRate(exchangeRate);
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "2012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e00\u822c\u6c47\u6b3eEDIT MODE", (String)"Pay2012Impl_1", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

