/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.services.swap;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.banks.cmb.wlbl.services.swap.BankPubGet0002Impl;
import kd.ebg.aqap.banks.cmb.wlbl.services.swap.CustomerPubPush0003Impl;
import kd.ebg.aqap.banks.cmb.wlbl.services.swap.SMSCheck0004Impl;
import kd.ebg.aqap.banks.cmb.wlbl.services.swap.SMSInfo;
import kd.ebg.aqap.banks.cmb.wlbl.utils.KeyStoreUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;

public class SwapPubKeyImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SwapPubKeyImpl.class);

    public void process(BankHeader header) {
        String status = KeyStoreUtils.currentStatus(header);
        if ("END".equalsIgnoreCase(status)) {
            return;
        }
        if ("0002".equalsIgnoreCase(status)) {
            logger.info("\u9996\u6b21\u516c\u94a5\u4ea4\u6362\u5f00\u59cb...");
            String pubKey = new BankPubGet0002Impl().send(false, "0");
            logger.info("\u94f6\u884c\u516c\u94a5\u83b7\u53d6\u5b8c\u6210{}", (Object)pubKey);
            KeyStoreUtils.upsertBankPub(header, pubKey, true);
            logger.info("\u94f6\u884c\u516c\u94a5\u4fdd\u5b58\u6210\u529f...");
            SMSInfo smsInfo = new CustomerPubPush0003Impl().send(false);
            KeyStoreUtils.updateCheckCode(header, smsInfo.getSmsCode());
            KeyStoreUtils.nextStatus(header, "0004");
            logger.info("\u5ba2\u6237\u516c\u94a5\u7ef4\u62a4\u6210\u529f...");
            new SMSCheck0004Impl().send(smsInfo);
            KeyStoreUtils.nextStatus(header, "END");
            logger.info("\u68c0\u67e5SMS OTP\u6210\u529f...");
            logger.info("\u9996\u6b21\u516c\u94a5\u4ea4\u6362\u5b8c\u6210...");
        } else if ("0003".equalsIgnoreCase(status)) {
            logger.info("\u516c\u94a5\u4ea4\u6362\u5f00\u59cb,\u5f53\u524d\u9636\u6bb5{}...", (Object)status);
            SMSInfo smsInfo = new CustomerPubPush0003Impl().send(false);
            KeyStoreUtils.updateCheckCode(header, smsInfo.getSmsCode());
            KeyStoreUtils.nextStatus(header, "0004");
            logger.info("\u5ba2\u6237\u516c\u94a5\u7ef4\u62a4\u6210\u529f...");
            new SMSCheck0004Impl().send(smsInfo);
            KeyStoreUtils.nextStatus(header, "END");
            logger.info("\u68c0\u67e5SMS OTP\u6210\u529f...");
            logger.info("\u516c\u94a5\u4ea4\u6362\u5b8c\u6210...");
        } else if ("00021".equalsIgnoreCase(status)) {
            try (TXHandle h = TX.requiresNew();){
                logger.info("\u975e\u9996\u6b21\u516c\u94a5\u4ea4\u6362\u5f00\u59cb,\u5f53\u524d\u9636\u6bb5{}...", (Object)status);
                String pubKey = new BankPubGet0002Impl().send(true, "0");
                logger.info("\u94f6\u884c\u516c\u94a5\u83b7\u53d6\u5b8c\u6210{}", (Object)pubKey);
                new CustomerPubPush0003Impl().send(true);
                logger.info("\u5ba2\u6237\u516c\u94a5\u7ef4\u62a4\u6210\u529f...");
                logger.info("\u5f00\u59cb\u94f6\u884c\u516c\u94a5\u66f4\u65b0...");
                new BankPubGet0002Impl().send(true, "1");
                logger.info("\u94f6\u884c\u516c\u94a5\u66f4\u65b0\u5b8c\u6210{}", (Object)pubKey);
                KeyStoreUtils.updateBankPub(header, pubKey);
                KeyStoreUtils.nextStatus(header, "END");
            }
        } else if ("0004".equalsIgnoreCase(status)) {
            logger.info("\u975e\u9996\u6b21\u516c\u94a5\u4ea4\u6362\u5f00\u59cb,\u5f53\u524d\u9636\u6bb5{}...", (Object)status);
            SMSInfo smsInfo = new SMSInfo(RequestContextUtils.getBankParameterValue((String)"phone_nums"), RequestContextUtils.getBankParameterValue((String)"check_code"));
            new SMSCheck0004Impl().send(smsInfo);
            KeyStoreUtils.nextStatus(header, "END");
            logger.info("\u68c0\u67e5SMS OTP\u6210\u529f...");
        } else if ("00031".equalsIgnoreCase(status)) {
            logger.info("\u975e\u9996\u6b21\u7ef4\u62a4\u5ba2\u6237\u516c\u94a5\u5f00\u59cb...");
            new CustomerPubPush0003Impl().send(true);
            KeyStoreUtils.nextStatus(header, "END");
            logger.info("\u5ba2\u6237\u516c\u94a5\u7ef4\u62a4\u6210\u529f...");
        } else {
            logger.error("\u672a\u5904\u7406\u7684\u72b6\u6001{}\u3002", new Object[]{status});
        }
    }
}

