/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.utils;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.repository.bank.login.BankLoginConfigRepository;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class KeyStoreUtils {
    private static BankLoginConfigRepository configRepository = BankLoginConfigRepository.getInstance();
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(KeyStoreUtils.class);

    public static String getRSA() {
        String rsa = KeyStoreUtils.intoString("customer_pri_key_cert");
        if (StringUtils.isEmpty((String)rsa)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5546\u6237\u79c1\u94a5\u5fc5\u586b\uff0c\u8bf7\u5728\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8\u201c>\u201d\u94f6\u4f01\u8fde\u63a5\u914d\u7f6e\u201c>\u201d\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u201c>\u201d\u8bc1\u4e66\u79d8\u94a5\u914d\u7f6e\u201c\u5185\u914d\u7f6e\u5546\u6237\u79c1\u94a5\u3002", (String)"KeyStoreUtils_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]));
        }
        return rsa;
    }

    public static String getRSAPub() {
        String rsa = KeyStoreUtils.intoString("customer_pub_key_cert");
        if (StringUtils.isEmpty((String)rsa)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5546\u6237\u516c\u94a5\u5fc5\u586b\uff0c\u8bf7\u5728\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8\u201c>\u201d\u94f6\u4f01\u8fde\u63a5\u914d\u7f6e\u201c>\u201d\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u201c>\u201d\u8bc1\u4e66\u79d8\u94a5\u914d\u7f6e\u201c\u5185\u914d\u7f6e\u5546\u6237\u516c\u94a5\u3002", (String)"KeyStoreUtils_1", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]));
        }
        return rsa;
    }

    public static String getBankRSA() {
        return KeyStoreUtils.intoString("bank_pub_key_cert");
    }

    public static String getAES() {
        String aes = KeyStoreUtils.intoString("aes_key");
        if (StringUtils.isEmpty((String)aes)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5546\u6237\u5bf9\u79f0\u79d8\u94a5\u5fc5\u586b\uff0c\u8bf7\u5728\u201d\u67e5\u8be2\u4e0e\u652f\u4ed8\u201c>\u201d\u94f6\u4f01\u8fde\u63a5\u914d\u7f6e\u201c>\u201d\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u201c>\u201d\u8bc1\u4e66\u79d8\u94a5\u914d\u7f6e\u201c\u5185\u914d\u7f6e\u5546\u6237\u5bf9\u79f0\u79d8\u94a5\u6587\u4ef6\u3002", (String)"KeyStoreUtils_2", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]));
        }
        return aes;
    }

    public static byte[] getStorageData(String key) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(key, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            return new byte[0];
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        return DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
    }

    public static String intoString(String key) {
        return CipherInfoUtil.getKey((byte[])KeyStoreUtils.getStorageData(key));
    }

    public static void upsertBankPub(BankHeader header, String pub, boolean firstTime) {
        try (TXHandle h = TX.requiresNew();){
            if (firstTime) {
                KeyStoreUtils.saveBankPub(header, pub);
            } else {
                KeyStoreUtils.updateBankPub(header, pub);
            }
        }
    }

    public static void saveBankPub(BankHeader header, String pub) {
        DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"aqap_bd_cert");
        KeyStoreUtils.setDynamicParamater(entity, "bank_config_id", "bank_pub_key_cert");
        KeyStoreUtils.setDynamicParamater(entity, "bank_config_value_tag", DesUtil.encryptProxyCert((byte[])pub.getBytes(), (String)header.getCustomerID()));
        KeyStoreUtils.setDynamicParamater(entity, "bank_config_name", ResManager.loadKDString((String)"\u5546\u6237\u516c\u94a5", (String)"KeyStoreUtils_4", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]));
        KeyStoreUtils.setDynamicParamater(entity, "bank_login_id", header.getBankLoginID());
        KeyStoreUtils.setDynamicParamater(entity, "bank_version_id", header.getBankVersionID());
        KeyStoreUtils.setDynamicParamater(entity, "custom_id", header.getCustomerID());
        KeyStoreUtils.setDynamicParamater(entity, "file_name", "bank.pub");
        Date expire_time = Date.from(LocalDateTime.of(2099, 1, 1, 23, 59, 59).atZone(ZoneId.systemDefault()).toInstant());
        KeyStoreUtils.setDynamicParamater(entity, "expire_time", expire_time);
        KeyStoreUtils.setDynamicParamater(entity, "alert_day", 7);
        KeyStoreUtils.setDynamicParamater(entity, "type", "BANKLOGIN_CER");
        KeyStoreUtils.setDynamicParamater(entity, "is_alert", "true");
        KeyStoreUtils.setDynamicParamater(entity, "cert_source", "0");
        KeyStoreUtils.setDynamicParamater(entity, "cert_type", "9");
        SaveServiceHelper.save((IDataEntityType)entity.getDataEntityType(), (Object[])new DynamicObject[]{entity});
        KeyStoreUtils.nextStatus(header, "0003");
    }

    public static void updateBankPub(BankHeader header, String pub) {
        String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, acnt_no, type, cert_type, custom_id, file_name, expire_time, modifytime, is_alert, alert_day, cert_password, cert_source";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bd_cert", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_config_id", "=", (Object)"bank_pub_key_cert"), new QFilter("bank_login_id", "=", (Object)header.getBankLoginID()), new QFilter("custom_id", "=", (Object)header.getCustomerID()), new QFilter("type", "=", (Object)CertType.BANKLOGIN_CER.getType())});
        dynamicObject.set("bank_config_value_tag", (Object)DesUtil.encryptProxyCert((byte[])pub.getBytes(), (String)header.getCustomerID()));
        SaveServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new DynamicObject[]{dynamicObject});
    }

    public static void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            value = " ";
        }
        dynamicObject.set(key, value);
    }

    public static void updateCheckCode(BankHeader header, String value) {
        DynamicObject bankLogin = configRepository.loadByBankLoginIDAndCustomIDAndBankConfigID(header.getBankLoginID(), header.getCustomerID(), "check_code");
        bankLogin.set("bank_config_value", (Object)value);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bankLogin});
    }

    public static void nextStatus(BankHeader header, String nextStatus) {
        DynamicObject bankPubKeyConfig;
        DynamicObject bankLogin = configRepository.loadByBankLoginIDAndCustomIDAndBankConfigID(header.getBankLoginID(), header.getCustomerID(), "swap_status");
        ArrayList dynamicObjects = Lists.newArrayList((Object[])new DynamicObject[]{bankLogin});
        String status = bankLogin.getString("bank_config_value");
        bankLogin.set("bank_config_value", (Object)nextStatus);
        if ("0002".equalsIgnoreCase(status) && (bankPubKeyConfig = configRepository.loadByBankLoginIDAndCustomIDAndBankConfigID(header.getBankLoginID(), header.getCustomerID(), "bank_pub_key_cert")) != null) {
            bankPubKeyConfig.set("bank_config_value", (Object)"bank.pub");
            dynamicObjects.add(bankPubKeyConfig);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
    }

    public static String currentStatus(BankHeader header) {
        DynamicObject bankLogin = configRepository.findByBankLoginIDAndCustomIDAndBankConfigID(header.getBankLoginID(), header.getCustomerID(), "swap_status");
        return bankLogin.getString("bank_config_value");
    }
}

