/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.wlbl.services.swap.SwapPubKeyImpl;
import kd.ebg.aqap.banks.cmb.wlbl.utils.KeyStoreUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class MessageUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(MessageUtils.class);
    static String GCM_MODE = "AES_256/GCM/NOPADDING";

    public static JSONObject getReqHead(String bizCode) {
        JSONObject head = new JSONObject();
        head.put("msg_cd", (Object)bizCode);
        head.put("customerId", (Object)RequestContextUtils.getBankParameterValue((String)"customer_id"));
        head.put("userId", (Object)RequestContextUtils.getBankParameterValue((String)"user_id"));
        head.put("channel", (Object)"1501");
        head.put("language", (Object)"ZH_CN");
        head.put("reqIntfNo", (Object)Sequence.gen16Sequence());
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        head.put("dateTime", (Object)dateTime);
        return head;
    }

    public static JSONObject getReqHead(String bizCode, String seq) {
        JSONObject head = new JSONObject();
        head.put("msg_cd", (Object)bizCode);
        head.put("customerId", (Object)RequestContextUtils.getBankParameterValue((String)"customer_id"));
        head.put("userId", (Object)RequestContextUtils.getBankParameterValue((String)"user_id"));
        head.put("channel", (Object)"1501");
        head.put("language", (Object)"ZH_CN");
        head.put("reqIntfNo", (Object)seq);
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        head.put("dateTime", (Object)dateTime);
        return head;
    }

    public static void setRequestProperty(ConnectionFactory factory) {
        factory.setUri("/cmbwlb/api/enterpriseService/v1");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public static JSONObject getReqBody() {
        return new JSONObject();
    }

    public static String sendToBank(BankHeader header, String bizCode, JSONObject body) {
        SwapPubKeyImpl swapPubKey = new SwapPubKeyImpl();
        swapPubKey.process(header);
        return MessageUtils.send(bizCode, body);
    }

    public static String sendToBankForPay(BankHeader header, String bizCode, JSONObject body, String seq) {
        SwapPubKeyImpl swapPubKey = new SwapPubKeyImpl();
        swapPubKey.process(header);
        return MessageUtils.send(bizCode, body, seq);
    }

    public static String send(String bizCode, JSONObject body, boolean needEncrypt, boolean needSign) {
        JSONObject message = new JSONObject();
        JSONObject reqParams = new JSONObject();
        reqParams.put("head", (Object)MessageUtils.getReqHead(bizCode));
        reqParams.put("body", (Object)body);
        String content = reqParams.toJSONString();
        message.put("signInfo", (Object)(needSign ? MessageUtils.sign(content) : ""));
        message.put("aesKey", (Object)(needEncrypt ? MessageUtils.encryptByBankRSA(KeyStoreUtils.getAES()) : ""));
        message.put("rdCode", (Object)(needEncrypt ? MessageUtils.encryptByBankRSA("1234567812345678") : ""));
        message.put("customerId", (Object)RequestContextUtils.getBankParameterValue((String)"customer_id"));
        message.put("msg_cd", (Object)bizCode);
        if ("0002".equalsIgnoreCase(bizCode) && !needEncrypt) {
            message.put("head", (Object)MessageUtils.getReqHead(bizCode));
            message.put("body", (Object)body);
        } else {
            message.put("reqParams", (Object)MessageUtils.encryptAES256Str(content));
        }
        return message.toJSONString();
    }

    public static String send(String bizCode, JSONObject body, String seq) {
        JSONObject message = new JSONObject();
        JSONObject reqParams = new JSONObject();
        reqParams.put("head", (Object)MessageUtils.getReqHead(bizCode, seq));
        reqParams.put("body", (Object)body);
        String content = reqParams.toJSONString();
        message.put("signInfo", (Object)MessageUtils.sign(content));
        message.put("aesKey", (Object)MessageUtils.encryptByBankRSA(KeyStoreUtils.getAES()));
        message.put("rdCode", (Object)MessageUtils.encryptByBankRSA("1234567812345678"));
        message.put("customerId", (Object)RequestContextUtils.getBankParameterValue((String)"customer_id"));
        message.put("msg_cd", (Object)bizCode);
        message.put("reqParams", (Object)MessageUtils.encryptAES256Str(content));
        return message.toJSONString();
    }

    public static String send(String bizCode, JSONObject body) {
        return MessageUtils.send(bizCode, body, true, true);
    }

    public static JSONObject receive(String s) {
        return MessageUtils.receive(s, true);
    }

    public static JSONObject receive(String s, boolean needEncrypt) {
        JSONObject respParams;
        JSONObject response = JSON.parseObject((String)s);
        if (response.getJSONObject("head") == null && needEncrypt) {
            String respParamsStr = response.getString("respParams");
            respParamsStr = MessageUtils.decryptAES256(respParamsStr);
            logger.info("\u54cd\u5e94\u6570\u636e\uff1a{}", (Object)respParamsStr);
            respParams = JSON.parseObject((String)respParamsStr);
        } else {
            respParams = response;
        }
        JSONObject head = respParams.getJSONObject("head");
        JSONObject body = respParams.getJSONObject("body");
        String retCode = head.getString("retCode");
        String retMsg = head.getString("retMsg");
        if (!"EBCL0000".equalsIgnoreCase(retCode) || body == null) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)retMsg));
        }
        return body;
    }

    public static BigDecimal checkNumStrLegal(String nums) {
        try {
            return new BigDecimal(nums);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String checkRem(String rem, int maxLen) {
        char[] chars;
        StringBuilder newRem = new StringBuilder();
        if (StringUtils.isEmpty((String)rem)) {
            return "";
        }
        for (char aChar : chars = rem.toCharArray()) {
            if (MessageUtils.isNotContainChinese(Character.toString(aChar))) {
                --maxLen;
                newRem.append(aChar);
            } else if ((maxLen -= 3) >= 0) {
                newRem.append(aChar);
            }
            if (maxLen <= 0) break;
        }
        return newRem.toString();
    }

    public static String checkRem2(String rem, int maxLen) {
        StringBuilder newRem = new StringBuilder();
        if (StringUtils.isEmpty((String)rem)) {
            return "";
        }
        char[] chars = rem.toCharArray();
        boolean expand = false;
        boolean startFlag = false;
        for (char aChar : chars) {
            if (!startFlag && (aChar == ' ' || aChar == ':' || aChar == '-' || aChar == '\uff1a')) continue;
            startFlag = true;
            if (MessageUtils.isNotContainChinese(Character.toString(aChar))) {
                --maxLen;
                expand = Character.isDigit(aChar);
                newRem.append(aChar);
            } else {
                maxLen = expand ? (maxLen -= 6) : (maxLen -= 5);
                if (maxLen >= 0) {
                    newRem.append(aChar);
                }
                expand = false;
            }
            if (maxLen <= 0) break;
        }
        return newRem.toString();
    }

    public static boolean isNotContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5\uff01\uff0c\u3002\uff08\uff09\u300a\u300b\u201c\u201d\uff1f\uff1a\uff1b\u3010\u3011]");
        Matcher m = p.matcher(str);
        return !m.find();
    }

    private static Cipher getAESCipher(SecretKeySpec key, int type) {
        Cipher cipherInstance;
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            cipherInstance = Cipher.getInstance(GCM_MODE);
            cipherInstance.init(type, (Key)key, new GCMParameterSpec(128, "1234567812345678".getBytes()));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521d\u59cb\u5316AES Cipher\u51fa\u73b0\u5f02\u5e38\u3002", (String)"MessageUtils_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), (Throwable)e);
        }
        return cipherInstance;
    }

    public static String encryptAES256Str(String content) {
        logger.info("\u52a0\u5bc6\u524d\u62a5\u6587\uff1a{}", (Object)content);
        String key = KeyStoreUtils.getAES();
        return Base64.encodeBase64String((byte[])MessageUtils.encryptAES256(content, Base64.decodeBase64((String)key)));
    }

    public static String decryptAES256(String content) {
        String key = KeyStoreUtils.getAES();
        return MessageUtils.decryptAES256(content, Base64.decodeBase64((String)key));
    }

    public static byte[] encryptAES256(String content, byte[] bytePassword) {
        try {
            SecretKeySpec key = new SecretKeySpec(bytePassword, "AES");
            Cipher cipherInstance = MessageUtils.getAESCipher(key, 1);
            byte[] byteContent = content.getBytes("UTF-8");
            return cipherInstance.doFinal(byteContent);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }

    private static String decryptAES256(String content, byte[] bytePassword) {
        byte[] bContent;
        if (content == null || content.length() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u5bc6\u3002", (String)"MessageUtils_1", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]));
        }
        try {
            bContent = Base64.decodeBase64((String)content);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        try {
            SecretKeySpec key = new SecretKeySpec(bytePassword, "AES");
            Cipher cipherInstance = MessageUtils.getAESCipher(key, 2);
            byte[] crypted = cipherInstance.doFinal(bContent);
            return new String(crypted, "UTF-8");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }

    public static String sign(String content) {
        try {
            String privateKeyStr = KeyStoreUtils.getRSA();
            PrivateKey privateKey = MessageUtils.getPrivateKey(privateKeyStr);
            Signature signature = Signature.getInstance("MD5WithRSA");
            signature.initSign(privateKey);
            signature.update(content.getBytes("UTF-8"));
            return Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25%s\u3002", (String)"MessageUtils_2", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static String encryptByBankRSA(String content) {
        try {
            String publicKeyStr = KeyStoreUtils.getBankRSA();
            PublicKey publicKey = MessageUtils.getPublicKey(publicKeyStr);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            byte[] doFinal = cipher.doFinal(content.getBytes("UTF-8"));
            return Base64.encodeBase64String((byte[])doFinal);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"RSA\u52a0\u5bc6\u5931\u8d25%s\u3002", (String)"MessageUtils_3", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static PrivateKey getPrivateKey(String crtBase64) {
        try {
            byte[] baKey = Base64.decodeBase64((String)crtBase64);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(baKey));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u79c1\u94a5\u5931\u8d25%s\u3002", (String)"MessageUtils_4", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static PublicKey getPublicKey(String crtBase64) {
        try {
            byte[] baKey = Base64.decodeBase64((String)crtBase64);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(new X509EncodedKeySpec(baKey));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u79c1\u94a5\u5931\u8d25%s\u3002", (String)"MessageUtils_4", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static String convert2Purpose(PaymentInfo paymentInfo, String interfaceCode) {
        String exp = paymentInfo.getExplanation();
        String customId = EBContext.getContext().getCustomID();
        String bankVersion = "CMB_WLBL";
        return UseKeyWordService.getUseByKey((String)customId, (String)exp, (String)interfaceCode, (String)"C0003", (String)bankVersion);
    }
}

