/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.balance;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.banks.sjb.cms.utils.TPacker;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalancePacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalancePacker.class);

    public static String packHisBalance(BankBalanceRequest req) throws EBServiceException {
        BankAcnt acnt = req.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200501";
        Element ap = TPacker.createCommonHead(tr_code, req_no);
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)req.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"cnt_type", (String)"01");
        JDomUtils.addChild((Element)body, (String)"cycle", (String)"01");
        JDomUtils.addChild((Element)body, (String)"begin_date", (String)req.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)req.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return TCommon.createCommonMsg(xmlMsg);
    }
}

