/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.balance;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    public static EBBankBalanceResponse parseTodayBalance(BankBalanceRequest req, String rspStr) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        if (!"0_0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        String tr_acdt = head.getChildTextTrim("tr_acdt");
        String tr_time = head.getChildTextTrim("tr_time");
        Element body = ap.getChild("body");
        String cur_code = body.getChildTextTrim("cur_code");
        if (StringUtils.isEmpty((String)cur_code)) {
            cur_code = req.getBankCurrency();
        }
        String balance = body.getChildTextTrim("balance");
        String use_balance = body.getChildTextTrim("use_balance");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balances.add(balanceInfo);
        BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (BankAcnt)req.getAcnt());
        BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)req.getBankCurrency(), (String)cur_code);
        BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (String)(tr_acdt + tr_time), (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)balance);
        BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)use_balance);
        return new EBBankBalanceResponse(balances);
    }
}

