/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sjb.cms.services.detail.RespFileUtils;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);

    public static List<DetailInfo> parseTodayDetail(BankDetailRequest req, String rspStr) throws EBServiceException {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(1);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = TCommon.parseBankResponse(head);
        if (!"0_0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"DetailParser_1", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            logger.error("###\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
            return details;
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equalsIgnoreCase(file_flag)) {
            logger.info("##\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            content = new RespFileUtils().getRspFileData(file_name);
        } else {
            logger.info("###\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        String[][] rs = TCommon.parseMFS(content, recordNum, fieldNum);
        for (int k = 0; k < rs.length; ++k) {
            DetailInfo detailInfo = DetailParser.parseRecord(rs[k]);
            details.add(detailInfo);
        }
        logger.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===");
        return details;
    }

    private static DetailInfo parseRecord(String[] r2_k) throws EBServiceException {
        String acno = r2_k[1];
        String tr_currency = r2_k[2];
        String tr_acdt = r2_k[3];
        String tr_time = r2_k[4];
        String tranDate = "";
        String host_serial_no = r2_k[5];
        String acname = r2_k[7];
        String opp_acno = r2_k[8];
        String opp_acname = r2_k[10];
        String oppBank = r2_k[11];
        String crdr_flag = r2_k[23];
        String amt = r2_k[24];
        String balance = r2_k[25];
        String cert_batchno = r2_k[29];
        String cert_no = r2_k[30];
        String summary = r2_k[34];
        String postscript = r2_k[35];
        String payamt = r2_k[43];
        String rcvamt = r2_k[44];
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(acno);
        detailInfo.setAccName(acname);
        detailInfo.setOppAccNo(opp_acno);
        detailInfo.setOppAccName(opp_acname);
        detailInfo.setBankName(oppBank);
        detailInfo.setCurrency(tr_currency);
        try {
            if (!StringUtils.isEmpty((String)tr_acdt)) {
                tranDate = !StringUtils.isEmpty((String)tr_time) ? tr_acdt + tr_time : tr_acdt;
                detailInfo.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern("yyyyMMdd")));
                detailInfo.setTransTime(LocalDateTime.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
        }
        catch (Exception e) {
            logger.error("###[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u4ea4\u6613\u65e5\u671f\u62a5\u9519:" + tranDate, (Throwable)e);
        }
        if ("D".equalsIgnoreCase(crdr_flag)) {
            detailInfo.setDebitAmount(new BigDecimal(payamt));
            detailInfo.setCreditAmount(new BigDecimal("0.00"));
        }
        if ("C".equalsIgnoreCase(crdr_flag)) {
            detailInfo.setDebitAmount(new BigDecimal("0.00"));
            detailInfo.setCreditAmount(new BigDecimal(rcvamt));
        }
        if (!StringUtils.isEmpty((String)summary)) {
            detailInfo.setExplanation(summary);
        } else {
            detailInfo.setExplanation(postscript);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tr_acdt", (Object)tr_acdt);
        jsonObject.put("host_serial_no", (Object)host_serial_no);
        jsonObject.put("serialNo", (Object)host_serial_no.split("_")[0]);
        jsonObject.put("crdr_flag", (Object)crdr_flag);
        jsonObject.put("nCDFG", (Object)("D".equalsIgnoreCase(crdr_flag) ? "0" : "1"));
        jsonObject.put("amt", (Object)amt);
        String receiptNo = MatchRule.getInstance().getReceiptNo(acno, detailInfo.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonObject.toJSONString());
        detailInfo.setReceiptNo(receiptNo);
        detailInfo.setJsonMap(jsonObject.toJSONString());
        detailInfo.setBankDetailNo(host_serial_no);
        if (StringUtils.isNotEmpty((String)balance)) {
            detailInfo.setBalance(new BigDecimal(balance));
        }
        return detailInfo;
    }
}

