/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.payment.allocation;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.banks.sjb.cms.utils.TPacker;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);

    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        String tr_code = "300216";
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Element ap = TPacker.createCommonHead(tr_code, paymentInfo.getPackageId());
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toPlainString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"transtype", (String)PayPacker.getTransType(paymentInfo.getUseCn()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return TCommon.createCommonMsg(xmlMsg);
    }

    private static String getTransType(String type) throws EBServiceException {
        if (StringUtils.isEmpty((String)type)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayPacker_0", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]));
        }
        if (!ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"PayPacker_1", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]).equals(type) && !ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"PayPacker_2", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]).equals(type)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7528\u9014\u548c\u5212\u62e8\u4e0d\u7b26\u3002", (String)"PayPacker_3", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]));
        }
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"PayPacker_1", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]).equals(type)) {
            return "0";
        }
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"PayPacker_2", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]).equals(type)) {
            return "1";
        }
        return "";
    }
}

