/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.payment.company;

import java.util.List;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.banks.sjb.cms.utils.TPacker;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        String tr_code = "300001";
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Element ap = TPacker.createCommonHead(tr_code, paymentInfo.getPackageId());
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_type", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toPlainString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return TCommon.createCommonMsg(xmlMsg);
    }
}

