/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Packer;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private final int PAGE_SIZE = 100;
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/openApi/curDetQryYQAPI";
        factory.setUri(s);
        super.configFactory(factory);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        JSONObject headJson = Packer.packHeader();
        JSONObject bodyJson = new JSONObject();
        JSONObject accountArray = new JSONObject();
        accountArray.put("account", (Object)bankAcnt.getAccNo());
        bodyJson.put("accountArray", (Object)accountArray);
        JSONObject currencyArray = new JSONObject();
        currencyArray.put("currencyCode", (Object)bankDetailRequest.getBankCurrency());
        bodyJson.put("currencyArray", (Object)currencyArray);
        bodyJson.put("beginDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        bodyJson.put("endDate", (Object)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String currentPage = this.getCurrentPage();
        if (currentPage.equalsIgnoreCase("0")) {
            currentPage = "1";
            this.setCurrentPage(currentPage);
        }
        bodyJson.put("page", (Object)currentPage);
        bodyJson.put("pageSize", (Object)"100");
        JSONObject reqJson = new JSONObject();
        reqJson.put("head", (Object)headJson);
        reqJson.put("body", (Object)bodyJson);
        String reqData = reqJson.toJSONString();
        try {
            return Packer.encrytAndSign(reqData);
        }
        catch (IOException e) {
            this.logger.info("\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        String response;
        this.setLastPage(true);
        try {
            response = Parser.decryAndSignCheck(res);
        }
        catch (IOException e) {
            this.logger.error("\u67e5\u8be2\u660e\u7ec6\u62a5\u6587\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        BankResponse bankResponse = Parser.getResponse(response);
        if ("060901B00DD000080".equals(bankResponse.getResponseCode())) {
            return new EBBankDetailResponse(list);
        }
        if (!"000000".equals(bankResponse.getResponseCode())) {
            String exMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"DetailImpl_0", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)exMsg);
        }
        JSONObject resJson = JSONObject.parseObject((String)response);
        JSONObject resp = resJson.getJSONObject("data");
        String totalCount = resp.getString("count");
        if (StringUtils.isNotEmpty((String)totalCount)) {
            int i = Integer.parseInt(this.getCurrentPage());
            if (Integer.parseInt(totalCount) > i * 100) {
                this.setLastPage(false);
                this.setCurrentPage(i++);
            }
        }
        JSONObject transDetail = resp.getJSONObject("transDetail");
        JSONArray jsonArr = transDetail.getJSONArray("payDetail");
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (int i = 0; i < jsonArr.size(); ++i) {
            JSONObject json = jsonArr.getJSONObject(i);
            DetailInfo info = new DetailInfo();
            info.setAccName(bankAcnt.getAccName());
            info.setAccNo(bankAcnt.getAccNo());
            info.setOppAccName(json.getString("peerName"));
            String peerAcct = json.getString("peerAcct");
            info.setOppAccNo(peerAcct);
            info.setOppBankName(json.getString("peerBankName"));
            info.setCurrency(bankAcnt.getCurrency());
            String flag = json.getString("flag");
            String tranAmt = json.getString("tranAmt");
            if (flag != null && StringUtils.equals((String)"DR", (String)flag)) {
                info.setDebitAmount(new BigDecimal(tranAmt));
                info.setCreditAmount(BigDecimal.ZERO);
            } else {
                info.setDebitAmount(BigDecimal.ZERO);
                info.setCreditAmount(new BigDecimal(tranAmt));
            }
            info.setTransDate(LocalDate.parse(json.getString("txnDate"), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            info.setTransTime(LocalDateTime.parse(json.getString("txnDate") + json.getString("tranTime"), DateTimeFormatter.ofPattern("yyyy-MM-ddHH:mm:ss")));
            String bookAmt = json.getString("bookAmt");
            if (StringUtils.isNotEmpty((String)bookAmt)) {
                info.setBalance(new BigDecimal(bookAmt));
            }
            String summary = json.getString("remark");
            String bankDetailNo = json.getString("ref_no");
            info.setBankDetailNo(bankDetailNo);
            info.setExplanation(summary);
            if (info.getCreditAmount().compareTo(BigDecimal.ZERO) == 0 && summary.contains("_KD_")) {
                String kDRetFlag = BizNoUtil.getId((String)summary);
                if (kDRetFlag.contains("_KD_")) {
                    kDRetFlag = kDRetFlag.substring(kDRetFlag.length() - 4);
                }
                info.setPayBankDetailSeqID(kDRetFlag);
                String exp = BizNoUtil.getMsg((String)summary);
                info.setExplanation(exp);
            }
            info.setReceiptNo(bankDetailNo);
            String transferDate = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serialNo", (Object)bankDetailNo);
            jsonObject.put("transDate", (Object)transferDate);
            jsonObject.put("tranAmt", (Object)tranAmt);
            jsonObject.put("accNo", (Object)bankAcnt.getAccNo());
            jsonObject.put("cdFlag", (Object)flag);
            jsonObject.put("oppAccNo", (Object)peerAcct);
            String receiptNo = MatchRule.getInstance().getReceiptNo(bankAcnt.getAccNo(), transferDate, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            info.setJsonMap(jsonObject.toJSONString());
            info.setReceiptNo(receiptNo);
            list.add(info);
        }
        return new EBBankDetailResponse(list);
    }

    public boolean isSupportPage() {
        return true;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "curDetQryYQAPI";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u6237\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]);
    }
}

