/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.payment;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fbbk.api.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Packer;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/openApi/transAcctAPI";
        factory.setUri(s);
        super.configFactory(factory);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        String tran_category = RequestContextUtils.getBankParameterValue((String)"channel_id");
        String branch = RequestContextUtils.getBankParameterValue((String)"branch_id");
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject headJson = Packer.packHeader();
        JSONObject bodyJson = new JSONObject();
        String timeStamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
        String autoincrementNumber = Sequence.getAutoincrementNumber((int)5);
        String ref_no = tran_category + timeStamp + autoincrementNumber;
        bodyJson.put("ref_no", (Object)ref_no);
        paymentInfo.setBankRefID(ref_no);
        bodyJson.put("format", (Object)"");
        bodyJson.put("busi_type", (Object)"");
        bodyJson.put("tran_category", (Object)tran_category);
        bodyJson.put("tran_amt", (Object)paymentInfo.getAmount().setScale(2, 1).toString());
        bodyJson.put("payer_acct", (Object)paymentInfo.getAccNo());
        bodyJson.put("payer_name", (Object)paymentInfo.getAccName());
        bodyJson.put("branch", (Object)branch);
        bodyJson.put("payer_addr", (Object)"");
        bodyJson.put("payer_phone_no", (Object)"");
        bodyJson.put("payer_paper_type", (Object)"");
        bodyJson.put("payer_acct_code", (Object)"CA");
        bodyJson.put("payer_paper_no", (Object)"");
        bodyJson.put("actual_payer_acct", (Object)"");
        bodyJson.put("actual_payer_name", (Object)"");
        bodyJson.put("actual_payer_acct_type", (Object)"");
        bodyJson.put("payee_rcv_bank", (Object)paymentInfo.getIncomeCnaps());
        bodyJson.put("payee_name", (Object)paymentInfo.getIncomeAccName());
        bodyJson.put("payee_acct", (Object)paymentInfo.getIncomeAccNo());
        bodyJson.put("payee_bank_code", (Object)"");
        bodyJson.put("payee_city_code", (Object)"");
        bodyJson.put("cancel_no", (Object)"");
        bodyJson.put("payee_addr", (Object)"");
        bodyJson.put("rcv_bank_code", (Object)"");
        bodyJson.put("priority", (Object)"");
        if (paymentInfo.is2Individual()) {
            bodyJson.put("is_individual", (Object)"SA");
        } else {
            bodyJson.put("is_individual", (Object)"CA");
        }
        bodyJson.put("orig_msg_id", (Object)"");
        bodyJson.put("orig_branch_id", (Object)"");
        bodyJson.put("purpose", (Object)paymentInfo.getUseCN());
        bodyJson.put("postscript", (Object)paymentInfo.getExplanation());
        bodyJson.put("fast_flag", (Object)"0");
        bodyJson.put("operator", (Object)"");
        bodyJson.put("approval_opr", (Object)"");
        bodyJson.put("auth_opr", (Object)"");
        bodyJson.put("fee_flag", (Object)"");
        bodyJson.put("trial_flag", (Object)"N");
        LocalDateTime bookingTime = paymentInfo.getBookingTime();
        String delay_time = "N";
        if (bookingTime != null && bookingTime.isAfter(LocalDateTime.now())) {
            delay_time = bookingTime.format(DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss"));
            PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
        }
        bodyJson.put("delay_time", (Object)delay_time);
        bodyJson.put("teller", (Object)"");
        bodyJson.put("acqins_code", (Object)"");
        bodyJson.put("payer_mer_id", (Object)"");
        bodyJson.put("payer_mer_name", (Object)"");
        bodyJson.put("payer_mer_type", (Object)"");
        JSONObject reqJson = new JSONObject();
        reqJson.put("head", (Object)headJson);
        reqJson.put("body", (Object)bodyJson);
        String reqData = reqJson.toJSONString();
        try {
            return Packer.encrytAndSign(reqData);
        }
        catch (IOException e) {
            this.logger.error("\u4ed8\u6b3e\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        String response;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        try {
            response = Parser.decryAndSignCheck(responseStr);
        }
        catch (IOException e) {
            this.logger.error("\u4ed8\u6b3e\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        BankResponse bankResponse = Parser.getResponse(response);
        String rspCode = bankResponse.getResponseCode();
        if ("050700B0000229999".equalsIgnoreCase(rspCode) || "000000".equalsIgnoreCase(rspCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_0", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_1", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "transAcctAPI";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u667a\u80fd\u6c47\u8def\u8f6c\u8d26\u4ea4\u6613", (String)"PayImpl_2", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

