/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ljb.dc.service.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ljb.dc.service.utils.CommonPacker;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        JSONObject bankRequest = CommonPacker.createRequest(Sequence.gen16Sequence(), this.getBizCode());
        bankRequest.put("acctNo", (Object)request.getAcnt().getAccNo());
        bankRequest.put("currency", (Object)request.getBankCurrency());
        return bankRequest.toJSONString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String res) {
        JSONObject response = JSONObject.parseObject((String)res);
        JSONObject dto = response.getJSONObject("dto");
        String bookBal = dto.getString("bookBal");
        String avlBal = dto.getString("valBal");
        String frzBal = dto.getString("frzBal");
        String acctNo = dto.getString("acctNo");
        if (StringUtils.isEmpty((String)acctNo)) {
            acctNo = bankBalanceRequest.getAcnt().getAccNo();
        }
        String currency = dto.getString("currency");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acctNo);
        this.setCurrentBalance(balanceInfo, bookBal);
        this.setAvailableBalance(balanceInfo, avlBal);
        this.setFreezeBalance(balanceInfo, frzBal);
        balanceInfo.setBankCurrency(StringUtils.isEmpty((String)currency) ? bankBalanceRequest.getBankCurrency() : currency);
        return new EBBankBalanceResponse(Collections.singletonList(balanceInfo));
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "02030201A0205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-ljb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/json");
        super.configFactory(factory);
    }
}

