/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ljb.dc.service.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ljb.dc.service.utils.CommonPacker;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public String pack(BankDetailRequest request) {
        JSONObject bankRequest = CommonPacker.createRequest(Sequence.gen16Sequence(), this.getBizCode());
        bankRequest.put("assetNo", (Object)request.getAcnt().getAccNo());
        bankRequest.put("assetUnit", (Object)request.getBankCurrency());
        bankRequest.put("startDate", (Object)LocalDateUtil.formatDate((LocalDate)request.getStartDate()));
        bankRequest.put("endDate", (Object)LocalDateUtil.formatDate((LocalDate)request.getEndDate()));
        if ("0".equals(this.getCurrentPage())) {
            this.setCurrentPage("1");
        }
        bankRequest.put("start", (Object)this.getCurrentPage());
        bankRequest.put("size", (Object)50);
        return bankRequest.toJSONString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        JSONArray dtos;
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        JSONObject response = JSONObject.parseObject((String)res);
        String total = response.getString("total");
        String currentPage = this.getCurrentPage();
        int currentCount = Integer.parseInt(currentPage);
        if (StringUtils.isNotEmpty((String)total) && Integer.parseInt(total) > 50 && Integer.parseInt(total) >= currentCount + 50) {
            this.setLastPage(false);
            this.setCurrentPage(currentCount + 50);
        }
        if ((dtos = response.getJSONArray("dtos")).size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (int i = 0; i < dtos.size(); ++i) {
            try {
                DetailInfo detailInfo = new DetailInfo();
                String assetNo = dtos.getJSONObject(i).getString("assetNo");
                String assetUnit = dtos.getJSONObject(i).getString("assetUnit");
                String assetName = dtos.getJSONObject(i).getString("assetName");
                String trDate = dtos.getJSONObject(i).getString("trDate");
                String trTime = dtos.getJSONObject(i).getString("trTime");
                String hostSerialNo = dtos.getJSONObject(i).getString("hostSerialNo");
                String drcrFlag = dtos.getJSONObject(i).getString("drcrFlag");
                String amt = dtos.getJSONObject(i).getString("amt");
                String balance = dtos.getJSONObject(i).getString("balance");
                String oppAssetNo = dtos.getJSONObject(i).getString("oppAssetNo");
                String oppAssetName = dtos.getJSONObject(i).getString("oppAssetName");
                String oppBankName = dtos.getJSONObject(i).getString("oppBankName");
                String summary = dtos.getJSONObject(i).getString("summary");
                detailInfo.setAccNo(assetNo);
                detailInfo.setAccName(assetName);
                detailInfo.setCurrency(assetUnit);
                detailInfo.setTransDate(LocalDateUtil.parserDate((String)trDate));
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(trDate + trTime)));
                detailInfo.setOppAccName(oppAssetName);
                detailInfo.setOppAccNo(oppAssetNo);
                detailInfo.setOppBankName(oppBankName);
                detailInfo.setBankDetailNo(hostSerialNo);
                if (StringUtils.isNotEmpty((String)balance)) {
                    detailInfo.setBalance(new BigDecimal(balance));
                }
                detailInfo.setExplanation(summary);
                if (StringUtils.isEmpty((String)amt)) {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailAmountEmptyErrorTips());
                }
                if ("D".equals(drcrFlag)) {
                    detailInfo.setDebitAmount(new BigDecimal(amt));
                    detailInfo.setCreditAmount(new BigDecimal("0.0"));
                } else if ("C".equals(drcrFlag)) {
                    detailInfo.setCreditAmount(new BigDecimal(amt));
                    detailInfo.setDebitAmount(new BigDecimal("0.0"));
                } else {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailCDFlagErrorTips((String)drcrFlag));
                }
                detailInfo.setJsonMap(dtos.getJSONObject(i).toJSONString());
                String jsonStr = dtos.getJSONObject(i).toJSONString();
                String transDateStr = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getHeader().getAcnt().getAccNo(), transDateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                detailList.add(detailInfo);
                continue;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "02030201A0329";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-ljb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/json");
        super.configFactory(factory);
    }
}

