/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.balance.HisBalanceParser;
import kd.ebg.aqap.banks.ccb.dc.util.BankCurrencyMapping;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class FixedBalanceParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(HisBalanceParser.class);

    public List<String> parse(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        ArrayList<String> balanceList = new ArrayList<String>(16);
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element txInfo = root.getChild("TX_INFO");
        String accNo = ParserUtils.checkUnNullableElement((Element)txInfo, (String)"ACCT_NO");
        Element detailList = txInfo.getChild("DETAILLIST");
        List detailInfos = detailList.getChildren("DETAILINFO");
        if (null == detailInfos || 0 == detailInfos.size()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u5b9a\u671f\u6237\u7684\u5b50\u8d26\u6237\u4f59\u989d\u7684\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"FixedBalanceParser_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
        RequestContextUtils.setRunningParam((String)"LOCSTR1", (String)txInfo.getChildText("LOCSTR1"));
        for (int i = 0; i < detailInfos.size(); ++i) {
            boolean isExpired = false;
            Element detailinfo = (Element)detailInfos.get(i);
            String balance = detailinfo.getChildText("OPAC_AMT");
            if (StringUtils.isEmpty((String)balance)) {
                this.log.warn("\u5b9a\u671f\u6237{}\u7684\u5b50\u8d26\u6237{}\u7684\u4f59\u989d\u4e3a\u7a7a\u3002", new Object[]{accNo, i + 1});
                continue;
            }
            String currencyID = detailinfo.getChildText("CURR_COD");
            String dueDt = detailinfo.getChildText("DUE_DT");
            if (StringUtils.isNotEmpty((String)dueDt)) {
                LocalDate DUE_DT = LocalDate.parse(dueDt, DateTimeFormatter.ofPattern("yyyyMMdd"));
                isExpired = DUE_DT.isBefore(rqst.getStartDate());
            }
            String newBankCurrency = BankCurrencyMapping.getInstance().getNewBankCurrency(rqst.getBankCurrency());
            if (StringUtils.isEmpty((String)currencyID) || newBankCurrency.equalsIgnoreCase(currencyID) || rqst.getBankCurrency().equalsIgnoreCase(currencyID)) {
                if (!isExpired) {
                    balanceList.add(balance);
                } else {
                    this.log.info("\u5b9a\u671f\u6237{}\u7684\u5b50\u8d26\u6237{}\u5df2\u5230\u671f\uff0c\u5230\u671f\u65e5\u671f\u4e3a{}", new Object[]{accNo, i + 1, dueDt});
                }
            }
            this.log.info("\u5b9a\u671f\u6237{}\u7684\u5b50\u8d26\u6237{}\u7684\u4f59\u989d\u4e3a{}", new Object[]{accNo, i + 1, balance});
        }
        return balanceList;
    }
}

