/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.detail.fixed;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.detail.fixed.PSBKDetailImpl;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader(this.getBizCode(), request_sn);
        String PSBK_SQ_NO = RequestContextUtils.getRunningParam((String)"PSBK_SQ_NO");
        String DETAIL_LOCSTR1 = RequestContextUtils.getRunningParam((String)"DETAIL_LOCSTR1");
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"ACCT_NO", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"PSBK_SQ_NO", (String)(StringUtils.isEmpty((String)PSBK_SQ_NO) ? "" : PSBK_SQ_NO));
        JDomUtils.addChild((Element)txInfo, (String)"STRT_DT", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"END_DT", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"LOCSTR1", (String)(StringUtils.isEmpty((String)DETAIL_LOCSTR1) ? "" : DETAIL_LOCSTR1));
        JDomUtils.addChild((Element)txInfo, (String)"LOCSTR2", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)txInfo, (String)"MAXROW", (String)String.valueOf(20));
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        Element detailList;
        List detailInfos;
        EBBankDetailResponse bankDetailResponse = new EBBankDetailResponse();
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        bankDetailResponse.setDetails(detailInfoList);
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        Element txInfo = root.getChild("TX_INFO");
        this.checkLastPage(txInfo);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!"000000".equals(response.getResponseCode())) {
            this.logger.error(ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
            return bankDetailResponse;
        }
        String accNo = txInfo.getChildText("ACCT_NO");
        if (StringUtils.isEmpty((String)accNo)) {
            accNo = bankDetailRequest.getAcnt().getAccNo();
        }
        if (null == (detailInfos = (detailList = txInfo.getChild("DETAILLIST")).getChildren("DETAILINFO")) || 0 == detailInfos.size()) {
            return bankDetailResponse;
        }
        RequestContextUtils.setRunningParam((String)"DETAIL_LOCSTR1", (String)txInfo.getChildText("LOCSTR1"));
        for (int i = 0; i < detailInfos.size(); ++i) {
            Element txDetailInfo = (Element)detailInfos.get(i);
            DetailInfo detailInfo = new DetailInfo();
            String date = txDetailInfo.getChildText("WK_DATE");
            String amount = txDetailInfo.getChildText("TX_AMT");
            String cdFlag = txDetailInfo.getChildText("DR_CR_COD");
            String expCode = txDetailInfo.getChildText("DSCRP_COD");
            String type = txDetailInfo.getChildText("TX_TYP");
            String flowNo = txDetailInfo.getChildText("SEQ_NO_3");
            String currency = txDetailInfo.getChildText("CURR_COD");
            String incomeAccNo = txDetailInfo.getChildText("TRNAC_ACCT_NO");
            detailInfo.setAccNo(accNo);
            if (StringUtils.isEmpty((String)currency)) {
                this.logger.error(ShowTipUtil.getDetailCurrencyEmptyTips());
                continue;
            }
            detailInfo.setCurrency(currency);
            if (StringUtils.isEmpty((String)amount)) {
                this.logger.error(ShowTipUtil.getDetailAmountEmptyErrorTips());
                continue;
            }
            if ("1".equals(cdFlag)) {
                detailInfo.setDebitAmount(new BigDecimal(amount));
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
            } else if ("2".equals(cdFlag)) {
                detailInfo.setCreditAmount(new BigDecimal(amount));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            } else {
                this.logger.error(ShowTipUtil.getDetailCDFlagErrorTips((String)cdFlag));
                continue;
            }
            try {
                LocalDate transDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyyMMdd"));
                detailInfo.setTransDate(transDate);
                detailInfo.setTransTime(LocalDateTime.of(transDate, LocalTime.MIDNIGHT));
            }
            catch (Exception e) {
                this.logger.error(ShowTipUtil.getDetailTransDateParseErrorTips((String)date));
                continue;
            }
            detailInfo.setTransType(type);
            detailInfo.setOppAccNo(incomeAccNo);
            detailInfo.setExplanation(expCode);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(txDetailInfo);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("accNo", (Object)accNo);
            jsonObject.put("TRANDATE", (Object)date);
            jsonObject.put("Amount", (Object)amount);
            jsonObject.put("flowNo", (Object)flowNo);
            detailInfo.setJsonMap(jsonObject.toJSONString());
            detailInfoList.add(detailInfo);
        }
        return bankDetailResponse;
    }

    public String getCurrentPage() {
        String currentPage = super.getCurrentPage();
        if (StringUtils.isEmpty((String)currentPage) || "0".equals(currentPage)) {
            this.setCurrentPage(1);
            return "1";
        }
        return currentPage;
    }

    private void checkLastPage(Element tx_info) {
        String rspMaxRow = JDomUtils.getChildText((Element)tx_info, (String)"MAXROW");
        if (StringUtils.isEmpty((String)rspMaxRow)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(Integer.parseInt(rspMaxRow) > 20);
        }
        int nextPage = Integer.parseInt(this.getCurrentPage()) + 1;
        this.setCurrentPage(nextPage);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        ArrayList detailList = new ArrayList(16);
        EBBankDetailResponse bankDetailResponse = new PSBKDetailImpl().doBiz(request);
        List detailInfoList = bankDetailResponse.getDetails();
        if (CollectionUtil.isEmpty((Collection)detailInfoList)) {
            this.logger.warn("query 6WD401, return the collection of 'PSBK_SQ_NO' is empty.");
        } else {
            for (DetailInfo detailInfo : detailInfoList) {
                RequestContextUtils.setRunningParam((String)"PSBK_SQ_NO", (String)detailInfo.getBiz("PSBK_SQ_NO"));
                EBBankDetailResponse response = super.doBiz(request);
                List subDetailList = response.getDetails();
                if (!CollectionUtil.isNotEmpty((Collection)subDetailList)) continue;
                detailList.addAll(subDetailList);
            }
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "SK";
    }

    public String getBizCode() {
        return "6WD405";
    }

    public String getBizDesc() {
        return "6WD405";
    }

    public boolean isSupportPage() {
        return true;
    }

    public boolean match(BankDetailRequest bankDetailRequest) {
        return BankPropertyConfig.isFixedAcnt((String)bankDetailRequest.getAcnt().getAccNo());
    }
}

