/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.detail.fixed;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PSBKDetailImpl
extends AbstractDetailImpl {
    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader("6WD401", request_sn);
        String LOCSTR1 = RequestContextUtils.getRunningParam((String)"PSBK_LOCSTR1");
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"ACCT_NO", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"LOCSTR1", (String)(StringUtils.isEmpty((String)LOCSTR1) ? "" : LOCSTR1));
        JDomUtils.addChild((Element)txInfo, (String)"LOCSTR2", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)txInfo, (String)"MAXROW", (String)String.valueOf(20));
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        EBBankDetailResponse bankDetailResponse = new EBBankDetailResponse();
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        bankDetailResponse.setDetails(detailInfoList);
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        Element txInfo = root.getChild("TX_INFO");
        this.checkLastPage(txInfo);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element detailList = txInfo.getChild("DETAILLIST");
        List detailInfos = detailList.getChildren("DETAILINFO");
        if (null == detailInfos || 0 == detailInfos.size()) {
            return bankDetailResponse;
        }
        RequestContextUtils.setRunningParam((String)"PSBK_LOCSTR1", (String)txInfo.getChildText("LOCSTR1"));
        for (int i = 0; i < detailInfos.size(); ++i) {
            Element detailinfo = (Element)detailInfos.get(i);
            String psbk_sq_no = detailinfo.getChildText("PSBK_SQ_NO");
            if (!StringUtils.isNotEmpty((String)psbk_sq_no)) continue;
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setTransDate(LocalDate.now());
            detailInfo.setTransTime(LocalDateTime.now());
            detailInfo.setBiz("PSBK_SQ_NO", psbk_sq_no);
            detailInfoList.add(detailInfo);
        }
        return bankDetailResponse;
    }

    public String getCurrentPage() {
        String currentPage = super.getCurrentPage();
        if (StringUtils.isEmpty((String)currentPage) || "0".equals(currentPage)) {
            this.setCurrentPage(1);
            return "1";
        }
        return currentPage;
    }

    private void checkLastPage(Element tx_info) {
        String rspMaxRow = JDomUtils.getChildText((Element)tx_info, (String)"MAXROW");
        this.setLastPage(Integer.parseInt(rspMaxRow) > 20);
        int nextPage = Integer.parseInt(this.getCurrentPage()) + 1;
        this.setCurrentPage(nextPage);
    }

    public String getDeveloper() {
        return "SK";
    }

    public String getBizCode() {
        return "6WD401";
    }

    public String getBizDesc() {
        return "query base information of fixed account.";
    }

    public boolean isSupportPage() {
        return true;
    }

    public boolean match(BankDetailRequest request) {
        return false;
    }
}

