/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.company;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.acntcheck.AcntcheckHelper;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5efa\u884c\u5916\u8054\u5bf9\u516c\u652f\u4ed8\u4e1a\u52a1\u4e0d\u652f\u6301\u6279\u91cf\u652f\u4ed8\u3002", (String)"PayPacker_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
        Element root = null;
        Element txInfo = new Element("TX_INFO");
        if (paymentInfos[0].is2SameBank()) {
            root = CCB_DC_Packer.createTransactionHeader("6W8010", paymentInfos[0].getBankBatchSeqId());
            JDomUtils.addChild((Element)txInfo, (String)"PAY_ACCNO", (String)paymentInfos[0].getAccNo());
            JDomUtils.addChild((Element)txInfo, (String)"RECV_ACCNO", (String)paymentInfos[0].getIncomeAccNo());
            JDomUtils.addChild((Element)txInfo, (String)"RECV_ACC_NAME", (String)paymentInfos[0].getIncomeAccName());
            JDomUtils.addChild((Element)txInfo, (String)"CHK_RECVNAME", (String)"1");
            JDomUtils.addChild((Element)txInfo, (String)"RECV_OPENACC_DEPT", (String)paymentInfos[0].getIncomeBankName());
            if (BankBusinessConfig.needAcntValidate()) {
                AcntcheckHelper.acntCheck(paymentInfos[0].getIncomeAccNo(), paymentInfos[0].getIncomeAccName());
            }
        } else {
            root = CCB_DC_Packer.createTransactionHeader("6W8020", paymentInfos[0].getBankBatchSeqId());
            JDomUtils.addChild((Element)txInfo, (String)"PAY_ACCNO", (String)paymentInfos[0].getAccNo());
            JDomUtils.addChild((Element)txInfo, (String)"RECV_ACCNO", (String)paymentInfos[0].getIncomeAccNo());
            JDomUtils.addChild((Element)txInfo, (String)"RECV_ACC_NAME", (String)paymentInfos[0].getIncomeAccName());
            JDomUtils.addChild((Element)txInfo, (String)"RECV_OPENACC_DEPT", (String)paymentInfos[0].getIncomeBankName());
            String cnaps = paymentInfos[0].getIncomeCnaps();
            if (StringUtils.isEmpty((String)cnaps)) {
                cnaps = "";
            }
            JDomUtils.addChild((Element)txInfo, (String)"RECV_UBANKNO", (String)cnaps.trim());
        }
        JDomUtils.addChild((Element)txInfo, (String)"AMOUNT", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)txInfo, (String)"CUR_TYPE", (String)paymentInfos[0].getCurrency());
        String exp = CCB_DC_Packer.getExplain(paymentInfos[0]);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo[])paymentInfos);
        }
        JDomUtils.addChild((Element)txInfo, (String)"USEOF", (String)exp);
        JDomUtils.addChild((Element)txInfo, (String)"REM1", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"REM2");
        JDomUtils.addChild((Element)root, (Element)txInfo);
        JDomUtils.addChild((Element)root, (String)"SIGN_INFO", (String)"");
        JDomUtils.addChild((Element)root, (String)"SIGNCERT", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        String xml = JDomUtils.root2String((Element)root, (String)encoding);
        return xml + "\r\n\r\n";
    }
}

