/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.ecny.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.ecny.service.Packer;
import kd.ebg.aqap.banks.boc.ecny.service.Parser;
import kd.ebg.aqap.banks.boc.ecny.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.ecny.service.login.LoginAccessManager;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    static final int PAGE_SIZE = 50;

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("1");
        boolean lastPage = false;
        this.setLastPage(lastPage);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(request);
            if (Objects.nonNull(response) && Objects.nonNull(response.getDetails())) {
                detailInfos.addAll(response.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 50);
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankDetailRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            BankAcnt acnt = request.getHeader().getAcnt();
            String accNo = acnt.getAccNo();
            Element root = Packer.getHeader(token, "b2e0668");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0668-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0668-rq");
            JDomUtils.addChild((Element)rq, (String)"walletid", (String)accNo);
            JDomUtils.addChild((Element)rq, (String)"begindate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            JDomUtils.addChild((Element)rq, (String)"enddate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            JDomUtils.addChild((Element)rq, (String)"pagesize", (String)this.getCurrentPage());
            JDomUtils.addChild((Element)rq, (String)"numperpage", (String)"50");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0668-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("B001".equalsIgnoreCase(rspcod) || "B003".equalsIgnoreCase(rspcod)) {
            this.setLastPage(true);
        } else if ("B002".equalsIgnoreCase(rspcod)) {
            this.setLastPage(false);
        }
        if ("B003".equalsIgnoreCase(rspcod)) {
            return new EBBankDetailResponse(detailList);
        }
        if (!"B001".equalsIgnoreCase(rspcod) && !"B002".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25:%s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]), rspcod + rspmsg));
        }
        List list = trn.getChildren("b2e0668-rs");
        if (null == list || list.size() == 0) {
            return new EBBankDetailResponse(list);
        }
        for (Element record : list) {
            DetailInfo info;
            if (!"b2e0668-rs".equalsIgnoreCase(record.getName()) || (info = this.parseEachDetailB2e0035(record, request.getHeader().getAcnt())) == null) continue;
            detailList.add(info);
        }
        return new EBBankDetailResponse(detailList);
    }

    private DetailInfo parseEachDetailB2e0035(Element record, BankAcnt acnt) {
        Element status = record.getChild("status");
        Element rspCode = status.getChild("rspcod");
        if ("B001".equalsIgnoreCase(rspCode.getTextTrim())) {
            DetailInfo detail = new DetailInfo();
            String transstatus = record.getChildTextTrim("transstatus");
            if (!"03".equals(transstatus)) {
                return null;
            }
            String payAcntNumber = record.getChildTextTrim("walletno");
            String payAcntName = record.getChildTextTrim("walletname");
            String objwletinstno = record.getChildTextTrim("objwletinstno");
            BankAcnt payAcnt = new BankAcnt();
            payAcnt.setAccName(payAcntName);
            payAcnt.setAccNo(payAcntNumber);
            payAcnt.setCnaps(objwletinstno);
            detail.setAccNo(payAcntNumber);
            detail.setAccName(payAcntName);
            detail.setCurrency("CNY");
            String objectwalletn = record.getChildTextTrim("objectwalletn");
            String objectwalletname = record.getChildTextTrim("objectwalletname");
            String furinfo = record.getChildTextTrim("furinfo");
            if (StringUtils.isEmpty((String)objectwalletn)) {
                objectwalletn = record.getChildTextTrim("acctno");
                objectwalletname = record.getChildTextTrim("actname");
            }
            detail.setOppAccNo(objectwalletn);
            detail.setOppAccName(objectwalletname);
            detail.setExplanation(furinfo);
            String effdcflag = record.getChildTextTrim("effdcflag");
            String amount = record.getChildTextTrim("amount");
            String trantype = record.getChildTextTrim("trantype");
            if ("Dr".equals(effdcflag)) {
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(new BigDecimal(amount));
            } else if ("Cr".equals(effdcflag)) {
                detail.setCreditAmount(new BigDecimal(amount));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else {
                return null;
            }
            String transtime = record.getChildTextTrim("transtime");
            detail.setTransDate(LocalDate.parse(transtime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            detail.setTransTime(LocalDateTime.parse(transtime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
            detail.setJsonMap(jsonStr);
            return detail;
        }
        this.log.info("\u94f6\u884c\u8fd4\u56de\u72b6\u6001(rspcod\u4e0d\u662fB001,\u94f6\u4f01\u4e0d\u5904\u7406)" + rspCode.getTextTrim() + "," + status.getTextTrim());
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public String getDeveloper() {
        return "lei luo";
    }

    public String getBizCode() {
        return "b2e0668";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6570\u5e01\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3", (String)"DetailImpl_1", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]);
    }
}

