/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000063_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000063_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class OPCB000063
implements IMiniService<Root<Header4Send, OPCB000063_Send>, Root<Header4Receive, OPCB000063_Receive>, BankBalanceRequest, EBBankBalanceResponse> {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(OPCB000063.class);
    public static String transCode = "OPCB000063";

    public static OPCB000063 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000063_Send> getSendRoot(BankBalanceRequest rqst) throws Exception {
        Root<Header4Send, OPCB000063_Send> root = new Root<Header4Send, OPCB000063_Send>();
        OPCB000063_Send body = new OPCB000063_Send();
        body.setClientAcctNo(rqst.getAcnt().getAccNo());
        body.setDataDate(LocalDateUtil.formatDate((LocalDate)rqst.getStartDate()));
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000063_Receive> getrecvRoot(String rspStr) {
        return (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000063_Receive>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    @Override
    public EBBankBalanceResponse recvStrategy(Root<Header4Receive, OPCB000063_Receive> root, BankBalanceRequest bankBalanceRequest) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000063_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000003_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        List<OPCB000063_Receive.Bill> billList = body.getBillList();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        for (OPCB000063_Receive.Bill bill : billList) {
            BalanceInfo balance = new BalanceInfo();
            balance.setBankAcnt(bankBalanceRequest.getAcnt());
            balance.setBankCurrency(bankBalanceRequest.getCurrency());
            balance.setBalanceDateTime(bankBalanceRequest.getStartDate().atTime(0, 0));
            try {
                String ye = bill.getBalance();
                String kyye = bill.getActualBal();
                balance.setAvailableBalance(BigDecimalHelper.str2BigDecimalForBalance((String)kyye, (Boolean)true));
                balance.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)ye, (Boolean)false));
                String dataDate = bill.getDataDate();
                LocalDate localDate = LocalDateUtil.parserDate((String)dataDate);
                if (localDate.isBefore(bankBalanceRequest.getEndDate()) || localDate.isAfter(bankBalanceRequest.getEndDate())) continue;
                balance.setBalanceDateTime(bankBalanceRequest.getStartDate().atTime(0, 0));
            }
            catch (Exception e) {
                balance.setError(e.getMessage());
            }
            balanceInfos.add(balance);
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList(balanceInfos));
    }

    private static class Holder {
        private static final OPCB000063 instance = new OPCB000063();

        private Holder() {
        }
    }
}

