/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Element;

public class ResponseCheck {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ResponseCheck.class);

    public static void checkResponse(Element NBCBEBankData, String tips) throws EBServiceException {
        ResponseCheck.checkCommonException(NBCBEBankData, false);
        ResponseCheck.checkResponeCommon(NBCBEBankData, "");
    }

    public static void checkPayResponse(Element NBCBEBankData, String tips) throws EBServiceException {
        ResponseCheck.checkCommonException(NBCBEBankData, true);
        ResponseCheck.checkResponeCommon(NBCBEBankData, tips);
    }

    private static void checkResponeCommon(Element NBCBEBankData, String tips) throws EBServiceException {
        String retCode = DomHelper.getChildTextNotNull(NBCBEBankData, "retCode", ResManager.loadKDString((String)"\u4ea4\u6613\u8fd4\u56de\u7801", (String)"ResponseCheck_0", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        if (!"0000".equals(retCode) && !"000000".equals(retCode)) {
            String errorMsg = DomHelper.getChildText(NBCBEBankData, "errorMsg");
            errorMsg = null == errorMsg ? "" : errorMsg;
            throw EBExceiptionUtil.serviceException((String)(tips + ShowTipUtil.getResponseErrorTips((String)retCode, (String)errorMsg)));
        }
    }

    private static void checkCommonException(Element NBCBEBankData, boolean isPayBiz) throws EBServiceException {
        String sessionId = DomHelper.getChildTextNullAsBlank(NBCBEBankData, "sessionId");
        String errorCode = DomHelper.getChildTextNullAsBlank(NBCBEBankData, "errorCode");
        String errorMsg = DomHelper.getChildTextNullAsBlank(NBCBEBankData, "errorMsg");
        if ("-1".equals(sessionId)) {
            logger.info("\u5f53\u524d\u8fd4\u56desessionId = -1, \u8bbe\u7f6e\u4e0b\u4e00\u6b21\u4e1a\u52a1\u91cd\u65b0\u767b\u5f55\u83b7\u5f97Session.");
            LoginAndOut.getLoginAndOut().setNeedNewLoginSession();
        }
        if ("-1".equals(sessionId) && "20000".equals(errorCode)) {
            if (errorMsg.contains("session")) {
                String msg = "";
                msg = isPayBiz ? ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4f1a\u8bdd\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u652f\u4ed8\u64cd\u4f5c\u5728\u94f6\u884c\u7aef\u7684\u5904\u7406\u7ed3\u679c\u540e\uff0c\u518d\u8fdb\u884c\u76f8\u5e94\u5904\u7406\u3002", (String)"ResponseCheck_3", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u94f6\u884c\u4f1a\u8bdd\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u67e5\u8be2\u64cd\u4f5c\u3002", (String)"ResponseCheck_4", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
                logger.info(msg);
                throw EBExceiptionUtil.serviceException((String)msg);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\u578b\u54cd\u5e94, \u94f6\u884c\u8fd4\u56de\u7801(errorCode):%1$s,\u9519\u8bef\u4fe1\u606f(errorMsg):%2$s", (String)"ResponseCheck_8", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), errorCode, errorMsg));
        }
    }
}

