/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.balance;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.EBBizType;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.ResponseCheck;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        if (this.isNormalAccountType(request)) {
            Element NBCBEBankData = new Element("NBCBEBankData");
            NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Query(), "srv054_queryDayBalance", EBBizType.HIS_BALANCE);
            Element opReq = new Element("opReq");
            JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
            JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)RequestContextUtils.getRequestContext().getBankRequestSeq());
            JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
            Element ReqParam = new Element("ReqParam");
            JDomUtils.addChild((Element)opReq, (Element)ReqParam);
            JDomUtils.addChild((Element)ReqParam, (String)"ZHHA", (String)request.getAcnt().getAccNo());
            JDomUtils.addChild((Element)ReqParam, (String)"KSSJ", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            JDomUtils.addChild((Element)ReqParam, (String)"JSSJ", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)"null");
            return DomHelper.doc2StringPlain(new Document(NBCBEBankData), RequestContextUtils.getCharset());
        }
        String msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u975e\u666e\u901a\u7c7b\u578b\u8d26\u6237\u67e5\u8be2\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
        logger.error(msg);
        throw EBExceiptionUtil.serviceException((String)msg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element NBCBEBankData = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        ResponseCheck.checkResponse(NBCBEBankData, ResManager.loadKDString((String)"\u5386\u53f2\u989d\u67e5\u8be2\u4e1a\u52a1", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
        Element list = DomHelper.getChildElementNotNull(opRep, "list");
        List rows = list.getChildren("row");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(8);
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String ZHHA = DomHelper.getChildTextNotNull(row, "ZHHA");
            String YUER = DomHelper.getChildTextNotNull(row, "YUER", ResManager.loadKDString((String)"\u8d26\u9762\u4f59\u989d", (String)"HisBalanceImpl_2", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String JYRQ = DomHelper.getChildTextNotNull(row, "JYRQ", ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            BalanceInfo balance = new BalanceInfo();
            this.setBankAcnt(balance, request.getBankAcntList(), ZHHA);
            this.setBalanceDateTime(balance, JYRQ + "000000", DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss"));
            this.setCurrentBalance(balance, YUER);
            this.setBankCurrency(balance, request.getCurrency());
            balances.add(balance);
        }
        return new EBBankBalanceResponse(balances);
    }

    private BigDecimal convert(String amt, String tips) throws EBServiceException {
        try {
            return BigDecimalHelper.add((String)"0.00", (String)amt);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8f6c\u6362%1$s\u51fa\u9519,\u5f85\u8f6c\u6362\u7684\u503c\u4e3a:%2$s", (String)"HisBalanceImpl_4", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), tips, amt), (Throwable)e);
        }
    }

    public String getDeveloper() {
        return "deng_xu";
    }

    public String getBizCode() {
        return "srv054_queryDayBalance";
    }

    public String getBizDesc() {
        return EBBizType.HIS_BALANCE.getBizName();
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }

    public LocalDate limitDate() {
        return null;
    }

    public boolean isNormalAccountType(BankBalanceRequest request) {
        String acntType = BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo());
        return StrUtil.isEmpty((String)acntType) ? false : "normal".equalsIgnoreCase(acntType.trim());
    }
}

