/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment.company;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.EBBizType;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.banks.nbcb.dc.service.sign.SignService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class PayPacker {
    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        if (paymentInfo.is2SameBank()) {
            return PayPacker.pack4SameBank(paymentInfo);
        }
        return PayPacker.pack4DiffBank(paymentInfo);
    }

    private static String pack4SameBank(PaymentInfo paymentInfo) throws EBServiceException {
        Element NBCBEBankData = new Element("NBCBEBankData");
        NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Pay(), "srv006_singleInnerTransfer", EBBizType.PAY_SAME_BANK);
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        JDomUtils.addChild((Element)ReqParam, (String)"FKZH", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKZH", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKHM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)ReqParam, (String)"JYJE", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"YOTU", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)ReqParam, (String)"JTBZ", (String)"0");
        String signData = SignService.sign(opReq);
        JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)signData);
        String encoding = RequestContextUtils.getCharset();
        return DomHelper.doc2StringPlain(new Document(NBCBEBankData), encoding);
    }

    private static String pack4DiffBank(PaymentInfo paymentInfo) throws EBServiceException {
        Element NBCBEBankData = new Element("NBCBEBankData");
        NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Pay(), "srv007_singleOuterTransfer", EBBizType.PAY_DIFF_BANK);
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        JDomUtils.addChild((Element)ReqParam, (String)"FKZH", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKZH", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKHM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)ReqParam, (String)"SKYH", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)ReqParam, (String)"SKSH", (String)paymentInfo.getIncomeProvince());
        JDomUtils.addChild((Element)ReqParam, (String)"SKSI", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)ReqParam, (String)"JYJE", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"ZZLX", (String)"02");
        String urgent = paymentInfo.is2Urgent() ? "1" : "0";
        JDomUtils.addChild((Element)ReqParam, (String)"ZZLB", (String)urgent);
        JDomUtils.addChild((Element)ReqParam, (String)"YOTU", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)ReqParam, (String)"SKHH", (String)paymentInfo.getIncomeCnaps());
        String signData = SignService.sign(opReq);
        JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)signData);
        String encoding = RequestContextUtils.getCharset();
        return DomHelper.doc2StringPlain(new Document(NBCBEBankData), encoding);
    }
}

