/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment.individual;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.ResponseCheck;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PayParser.class);

    public static EBBankPayResponse parsePay(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        Element NBCBEBankData;
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String payType = PayParser.getPayType(paymentInfo);
        try {
            NBCBEBankData = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            ResponseCheck.checkPayResponse(NBCBEBankData, payType);
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u4ed8\u6b3e\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:%1$s\u3002", (String)"PayParser_14", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        try {
            Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
            Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
            String JYXH = DomHelper.getChildTextNotNull(opResult, "orderFlowNo", ResManager.loadKDString((String)"\u7f51\u94f6\u4ea4\u6613\u5e8f\u53f7", (String)"PayParser_1", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String JYZT = DomHelper.getChildTextNotNull(opResult, "orderState", ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"PayParser_2", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            logger.info("\u7f51\u94f6\u4ea4\u6613\u5e8f\u53f7:" + JYXH);
            logger.info("\u4ea4\u6613\u72b6\u6001:" + JYZT);
            if ("90".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayParser_4", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            } else if ("91".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_12", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            } else if ("99".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u94f6\u884c\u7cfb\u7edf\u5904\u7406\u4e2d", (String)"PayParser_5", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            } else if (!paymentInfo.is2SameBank() && "94".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406", (String)"PayParser_6", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u94f6\u4f01\u672a\u80fd\u7406\u89e3\u7684\u4ea4\u6613\u72b6\u6001\u7801:%1$s,\u8bf7\u5411\u94f6\u884c\u53cd\u9988", (String)"PayParser_15", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), JYZT), (String)JYZT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_13", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4ed8\u6b3e\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:%1$s\u3002", (String)"PayParser_16", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private static String getPayType(PaymentInfo paymentInfo) {
        if (paymentInfo.is2SameBank()) {
            return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26\u4e1a\u52a1", (String)"PayParser_10", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8de8\u884c\u6c47\u6b3e(\u540c\u57ce/\u5f02\u5730)\u4e1a\u52a1", (String)"PayParser_11", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
    }

    public static EBBankPayResponse parseSalaryPay(List<PaymentInfo> paymentInfos, String rspStr) {
        Element NBCBEBankData;
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String payType = PayParser.getPayType(paymentInfo);
        try {
            NBCBEBankData = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            ResponseCheck.checkPayResponse(NBCBEBankData, payType);
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u4ed8\u6b3e\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:%1$s\u3002", (String)"PayParser_14", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
        Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
        String JYXH = DomHelper.getChildTextNotNull(opResult, "JYXH", ResManager.loadKDString((String)"\u7f51\u94f6\u4ea4\u6613\u5e8f\u53f7", (String)"PayParser_1", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        String JYZT = DomHelper.getChildTextNotNull(opResult, "JYZT", ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"PayParser_2", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        logger.info("\u7f51\u94f6\u4ea4\u6613\u5e8f\u53f7:" + JYXH);
        logger.info("\u4ea4\u6613\u72b6\u6001:" + JYZT);
        if ("90".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JYZT, (String)"");
        } else if ("91".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JYZT, (String)"");
        } else if ("99".equals(JYZT) || "94".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u94f6\u884c\u7cfb\u7edf\u5904\u7406\u4e2d", (String)"PayParser_5", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u94f6\u4f01\u672a\u80fd\u7406\u89e3\u7684\u4ea4\u6613\u72b6\u6001\u7801:%1$s,\u8bf7\u5411\u94f6\u884c\u53cd\u9988", (String)"PayParser_15", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), JYZT), (String)JYZT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"PayParser_13", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

