/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment.individual.salary;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.EBBizType;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.banks.nbcb.dc.service.payment.individual.PayParser;
import kd.ebg.aqap.banks.nbcb.dc.service.payment.individual.salary.InnerAndOuterResultQuery;
import kd.ebg.aqap.banks.nbcb.dc.service.sign.SignService;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class InnerAndOuterWageAgency
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InnerAndOuterResultQuery.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "srv011_innerAndOuterWageAgency";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element NBCBEBankData = new Element("NBCBEBankData");
        NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Pay(), "srv011_innerAndOuterWageAgency", EBBizType.PAY_INDIV_SALARY);
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        JDomUtils.addChild((Element)ReqParam, (String)"FKZH", (String)paymentInfo.getAccNo());
        BigDecimal sumAmount = new BigDecimal("0");
        for (PaymentInfo pi : paymentInfos) {
            BigDecimal amount = pi.getAmount();
            sumAmount = sumAmount.add(amount);
        }
        JDomUtils.addChild((Element)ReqParam, (String)"ZJE", (String)BigDecimalHelper.plain2((BigDecimal)sumAmount));
        JDomUtils.addChild((Element)ReqParam, (String)"SHMU", (String)(paymentInfos.size() + ""));
        Element list = new Element("list");
        JDomUtils.addChild((Element)ReqParam, (Element)list);
        StringBuilder signString = new StringBuilder();
        signString.append(paymentInfo.getAccNo());
        signString.append("--");
        signString.append(BigDecimalHelper.plain2((BigDecimal)sumAmount));
        signString.append("|");
        for (PaymentInfo pi : paymentInfos) {
            Element row = new Element("row");
            JDomUtils.addChild((Element)list, (Element)row);
            JDomUtils.addChild((Element)row, (String)"SKYH", (String)pi.getIncomeCnaps());
            JDomUtils.addChild((Element)row, (String)"SKZH", (String)pi.getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"SKHM", (String)pi.getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"JYJE", (String)BigDecimalHelper.plain2((BigDecimal)pi.getAmount()));
            JDomUtils.addChild((Element)row, (String)"KHLS", (String)pi.getBankSerialNo());
            String remark = pi.getExplanation();
            JDomUtils.addChild((Element)row, (String)"BEIZ", (String)(null == remark ? "" : remark));
            signString.append(pi.getIncomeCnaps());
            signString.append("-");
            signString.append(pi.getIncomeAccNo());
            signString.append("-");
            signString.append(pi.getIncomeAccName());
            signString.append("-");
            signString.append(BigDecimalHelper.plain2((BigDecimal)pi.getAmount()));
            signString.append("-");
            signString.append(pi.getBankSerialNo());
            signString.append("|");
        }
        String signData = SignService.sign(signString.toString());
        JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)signData);
        String encoding = RequestContextUtils.getCharset();
        return DomHelper.doc2StringPlain(new Document(NBCBEBankData), encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parseSalaryPay(request.getPaymentInfos(), responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }
}

