/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbb.dc.services.payment.single;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scbb.dc.services.payment.single.QueryPayImpl;
import kd.ebg.aqap.banks.scbb.dc.services.utils.CommonUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EBankSingleTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u652f\u4ed8", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-scbb-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)CommonUtil.buildHead("B2EBankSingleTransfer", paymentInfo.getBankDetailSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"Amount", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"Remark", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"UnionDeptId", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"PayeeBankName", (String)paymentInfo.getIncomeBankName());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        CommonUtil.resSuccessCheck(rspStr);
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element element = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = element.getChild("Body");
        String returnCode = body.getChildText("ReturnCode");
        String msg = body.getChildText("ReturnMsg");
        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)returnCode, (String)msg);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        String uri = "/web_eibs/B2EBankSingleTransfer.do?userPassword=" + RequestContextUtils.getParameter().getBankParameter("password") + "&SIGDATA=1";
        factory.setUri(uri);
        super.configFactory(factory);
    }
}

