/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.opa.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.opa.BankBussinessConfig;
import kd.ebg.aqap.banks.boc.opa.services.utils.BOCRequest;
import kd.ebg.aqap.banks.boc.opa.services.utils.BOCUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetaIlImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetaIlImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage(1);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
            this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + 1));
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BOCRequest request = new BOCRequest();
        BOCRequest.MsgBody msgBody = new BOCRequest.MsgBody();
        BankAcnt acnt = bankDetailRequest.getAcnt();
        JSONObject data = new JSONObject();
        String triSignId = BankBussinessConfig.getTriSignId(acnt.getAccNo());
        if (StringUtils.isEmpty((String)triSignId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e09\u65b9\u7b7e\u7ea6ID\u4e3a\u7a7a,\u8bf7\u5148\u8fdb\u884c\u4e09\u65b9\u7b7e\u7ea6\u3002", (String)"DetaIlImpl_0", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        data.put("triSignId", (Object)triSignId);
        data.put("accountNum", (Object)bankDetailRequest.getAcnt().getAccNo());
        data.put("startDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        data.put("endDate", (Object)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        data.put("transType", (Object)"A");
        data.put("begNum", (Object)this.getCurrentPage());
        data.put("queryNum", (Object)"50");
        msgBody.setData(data.toJSONString());
        request.setMsgBody(msgBody);
        return BOCUtil.goRequest(request, bankDetailRequest.getHeader().getCustomerID());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(8);
        JSONObject data = BOCUtil.handleResponse(s);
        JSONObject kdEXT = data.getJSONObject("kdExt");
        if (Objects.nonNull(kdEXT)) {
            logger.info("\u65e0\u4ea4\u6613\u660e\u7ec6");
            return new EBBankDetailResponse(detailInfos);
        }
        String recordCount = data.getString("recordCount");
        if ("50".equalsIgnoreCase(recordCount)) {
            this.setLastPage(false);
        }
        JSONArray transList = data.getJSONArray("transList");
        for (int i = 0; i < transList.size(); ++i) {
            JSONObject trans = transList.getJSONObject(i);
            DetailInfo detailInfo = new DetailInfo();
            String vchnum = trans.getString("vchnum");
            String businessId = trans.getString("businessId");
            String transId = trans.getString("businessId");
            String amount = trans.getString("amount");
            String postTransBalance = trans.getString("postTransBalance");
            String currency = trans.getString("currency");
            String transDate = trans.getString("transDate");
            String transTime = trans.getString("transTime");
            String creditDebitFlag = trans.getString("creditDebitFlag");
            String payerAcctNum = trans.getString("payerAcctNum");
            String payerAccountName = trans.getString("payerAccountName");
            String payeeAcctNum = trans.getString("payeeAcctNum");
            String payeeAccountName = trans.getString("payeeAccountName");
            String payeeCnapsName = trans.getString("payeeCnapsName");
            String summary = trans.getString("summary");
            String transPostscript = trans.getString("transPostscript");
            detailInfo.setBalance(new BigDecimal(postTransBalance));
            if ("C".equalsIgnoreCase(creditDebitFlag)) {
                detailInfo.setCreditAmount(new BigDecimal(amount));
                detailInfo.setDebitAmount(BigDecimal.ZERO);
            } else if ("D".equalsIgnoreCase(creditDebitFlag)) {
                detailInfo.setDebitAmount(new BigDecimal(amount));
                detailInfo.setCreditAmount(BigDecimal.ZERO);
            }
            detailInfo.setCurrency(currency);
            LocalDateTime tt = LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss"));
            LocalDate td = tt.toLocalDate();
            detailInfo.setTransDate(td);
            detailInfo.setTransTime(tt);
            if (!StringUtils.isEmpty((String)transPostscript)) {
                if (!StringUtils.isEmpty((String)summary)) {
                    detailInfo.setExplanation(transPostscript + "-" + summary);
                } else {
                    detailInfo.setExplanation(transPostscript);
                }
            } else {
                detailInfo.setExplanation(summary);
            }
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfo.setBankName(bankDetailRequest.getAcnt().getBankName());
            detailInfo.setOppAccNo(payeeAcctNum);
            detailInfo.setOppAccName(payeeAccountName);
            detailInfo.setOppBankName(payeeCnapsName);
            detailInfo.setJsonMap(trans.toJSONString());
            detailInfo.setBankDetailNo(vchnum);
            detailInfos.add(detailInfo);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "cw";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/eztdg-framework/igtb/finance/v1/queryTransDetail");
        factory.setHttpHeader("from_product", "third");
        factory.setHttpHeader("target_product", "IGTBNET-LCA");
        factory.setHttpHeader("Content-type", "application/json");
        factory.setHttpHeader("interaction_id", "o.tdg.igtbnet-lca0008");
    }
}

