/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BOCHK_DC_BankBatchSeqIdCreator
implements IBankBatchSeqIDCreator {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BOCHK_DC_BankBatchSeqIdCreator.class);
    private static int currentCount = 0;
    private static int MAX_VALUE = 999;
    private static String lastDateTime = "";

    public String createBathId(PaymentInfo paymentInfo) {
        return BOCHK_DC_BankBatchSeqIdCreator.getPackageId();
    }

    public static synchronized String getPackageId() {
        String dateTime = BOCHK_DC_BankBatchSeqIdCreator.getCurrentDateTime();
        if (!dateTime.equals(lastDateTime)) {
            currentCount = 0;
        }
        if (currentCount == MAX_VALUE) {
            BOCHK_DC_BankBatchSeqIdCreator.sleep(1500L);
            dateTime = BOCHK_DC_BankBatchSeqIdCreator.getCurrentDateTime();
            currentCount = 0;
        }
        String seqNo3 = String.format("%03d", currentCount);
        String packageId = dateTime + seqNo3;
        lastDateTime = dateTime;
        ++currentCount;
        return packageId;
    }

    private static String getCurrentDateTime() {
        Date now = new Date();
        String date = DateTimeUtils.format((Date)now, (String)"yyyyMMdd");
        String time = DateTimeUtils.format((Date)now, (String)"HHmmss");
        try {
            EBContext context = EBContext.getContext();
            BankLoginConfigKey key = new BankLoginConfigKey();
            key.setBankLoginId(context.getBankLoginID());
            key.setBankVersionId(context.getBankVersionID());
            key.setCustomID(context.getCustomID());
            key.setBankConfigId("packageIDPrefix");
            BankLoginConfig bankLoginConfig = BankLoginConfigService.getInstance().getBankLoginConfig(key);
            if (bankLoginConfig != null && !StringUtils.isEmpty((String)bankLoginConfig.getBankConfigValue())) {
                date = bankLoginConfig.getBankConfigValue();
            }
        }
        catch (IllegalArgumentException | EBServiceException e) {
            logger.error("", e);
        }
        return date + time;
    }

    private static void sleep(long time) {
        if (time < 0L) {
            return;
        }
        try {
            Thread.sleep(time);
        }
        catch (Exception t) {
            logger.error("", (Throwable)t);
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public String getDeveloper() {
        return "qiang";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u751f\u6210\u6279\u6b21\u53f7BatchSeqID", (String)"BOCHK_DC_BankBatchSeqIdCreator_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]);
    }

    public String getBankBatchSeqID() {
        return BOCHK_DC_BankBatchSeqIdCreator.getPackageId();
    }

    public static void main(String[] args) {
        for (int i = 0; i <= 2000; ++i) {
            System.out.println(BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        }
    }
}

