/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class RegionBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(RegionBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        MappingAcctService service = MappingAcctService.getInstance();
        List acnts = bankBalanceRequest.getBankAcntList();
        BankAcnt acnt = (BankAcnt)acnts.get(0);
        Element root = BOCHK_DC_Packer.createRootWithHead(BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        Element Tx = JDomUtils.createRoot((String)"Tx");
        Element RgAcctBalanceREQ = JDomUtils.addChild((Element)Tx, (String)"RgAcctBalanceREQ");
        Element requests = JDomUtils.addChild((Element)RgAcctBalanceREQ, (String)"Requests").setAttribute("noOfRecord", String.valueOf(acnts.size()));
        Element record = JDomUtils.addChild((Element)requests, (String)"Record");
        String accNo = acnt.getAccNo();
        String iso = CurrencyUtils.convert2Iso((String)bankBalanceRequest.getCurrency(), (String)bankBalanceRequest.getHeader().getBankVersionID(), (String)bankBalanceRequest.getHeader().getCustomerID());
        accNo = service.mapping(accNo, iso);
        JDomUtils.addChild((Element)record, (String)"AcctNo", (String)accNo);
        String swiftCode = acnt.getSwiftCode();
        if (StringUtils.isEmpty((String)swiftCode)) {
            swiftCode = BankBusinessConfig.getBicCode(acnt.getAccNo());
        }
        if (!BankBusinessConfig.getBOC_HK_OTHER_OR_SELF_QRY()) {
            String country = acnt.getCountry();
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
            if (null == code && (code = ISOCountryUtils.getInstance().getCountryInfo(country)) == null) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56fd\u5bb6\u7801\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"DBS_DC_Packer_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), country));
            }
            JDomUtils.addChild((Element)record, (String)"Region", (String)code.geteChart2());
        } else {
            JDomUtils.addChild((Element)record, (String)"BicCode", (String)swiftCode);
        }
        JDomUtils.addChild((Element)record, (String)"TransCur", (String)bankBalanceRequest.getBankCurrency());
        JDomUtils.addChild((Element)root, (Element)Tx);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        MappingAcctService service = MappingAcctService.getInstance();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankRsp = BOCHK_DC_Parser.parseHead(root);
        if (!"S".equals(bankRsp.getResponseCode())) {
            String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
            String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a(%1$s,%2$s);\u9519\u8bef\u7801\uff1a%3$s,\u9519\u8bef\u8bf4\u660e\uff1a%4$s", (String)"RegionBalanceImpl_7", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), bankRsp.getResponseCode(), bankRsp.getResponseMessage(), ErrorCode, ErrorDesc));
        }
        Element RgAcctBalanceRLY = root.getChild("Tx").getChild("RgAcctBalanceRLY");
        List records = RgAcctBalanceRLY.getChild("BalInfo").getChild("Result").getChildren("Record");
        String iso = CurrencyUtils.convert2Iso((String)bankBalanceRequest.getCurrency(), (String)bankBalanceRequest.getHeader().getBankVersionID(), (String)bankBalanceRequest.getHeader().getCustomerID());
        if (records.isEmpty()) {
            return new EBBankBalanceResponse((List)Lists.newArrayList());
        }
        Element record = (Element)records.get(0);
        String acctNo = record.getChildTextTrim("AcctNo");
        BankAcnt bankAcnt = this.search(bankBalanceRequest.getBankAcntList(), acctNo, iso);
        if (Objects.isNull(bankAcnt)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u7ed3\u679c\u672a\u5305\u542b\u5f85\u67e5\u8be2\u7684\u8d26\u6237\u3002", (String)"RegionBalanceImpl_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
        }
        String lastUpdateTime = record.getChildTextTrim("LastUpdateTime");
        LocalDateTime balanceTime = this.parseBalanceTime(lastUpdateTime);
        Element avalBalGrp = record.getChild("AvalBalGrp");
        if (Objects.isNull(avalBalGrp)) {
            return new EBBankBalanceResponse((List)Lists.newArrayList());
        }
        records = avalBalGrp.getChild("Result").getChildren("Record");
        Element target = null;
        for (Element element : records) {
            String cur = element.getChildText("Cur");
            if (!bankBalanceRequest.getBankCurrency().equalsIgnoreCase(cur)) continue;
            target = element;
            break;
        }
        if (Objects.isNull(target)) {
            return new EBBankBalanceResponse((List)Lists.newArrayList());
        }
        String avalBal = target.getChildText("AvalBalAmt");
        String ledBal = target.getChildText("LedBalAmt");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, bankAcnt);
        this.setAvailableBalance(balanceInfo, avalBal);
        this.setCurrentBalance(balanceInfo, ledBal);
        this.setBalanceDateTime(balanceInfo, balanceTime);
        this.setBankCurrency(balanceInfo, target.getChildText("Cur"));
        String mappingAcc = service.mapping(acctNo, iso);
        balanceInfo.setExtraBankAcnt(mappingAcc);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    private LocalDateTime parseBalanceTime(String LastUpdateTime) {
        LocalDateTime balanceTime;
        String back_up = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE) + "000000";
        try {
            balanceTime = LocalDateTime.parse(LastUpdateTime, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm z"));
        }
        catch (Exception e) {
            return LocalDateTime.parse(back_up, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        return balanceTime;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }

    public BankAcnt search(List<BankAcnt> bankAcnts, String accNo, String iso) {
        MappingAcctService service = MappingAcctService.getInstance();
        for (BankAcnt bankAcnt : bankAcnts) {
            if (!accNo.equalsIgnoreCase(service.mapping(bankAcnt.getAccNo(), iso))) continue;
            return bankAcnt;
        }
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RgAcctBalanceREQ";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.getBOC_HK_OTHER_OR_SELF_QRY() || BankBusinessConfig.isRegionBalanceQuery();
    }
}

