/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.fasterPayment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.banks.bochk.dc.services.payment.fasterPayment.QueryFasterPayImpl;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FastPayImpl
extends AbstractPayImpl
implements IPay {
    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryFasterPayImpl.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        try {
            la.getToken();
            for (int i = 0; i < paymentInfos.size(); ++i) {
                String cur = ((PaymentInfo)paymentInfos.get(i)).getPayCurrency();
                if ("CNY".equals(cur) || "HKD".equals(cur)) continue;
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"--<\u8f49\u6578\u5feb >\u4ed8\u6b3e\u53ea\u652f\u6301\u3010\u6e2f\u5e01\u6216\u4eba\u6c11\u5e01\u3011\u5e01\u79cd--\u8bf7\u68c0\u67e5\u6536\u6b3e\u5e01\u79cd", (String)"FastPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            }
            Element root = BOCHK_DC_Packer.createRootWithHead(((PaymentInfo)paymentInfos.get(0)).getPackageId());
            Element tx = new Element("Tx");
            Element transferReq = JDomUtils.addChild((Element)tx, (String)"TransferREQ");
            JDomUtils.addChild((Element)transferReq, (String)"DebitAcctNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
            JDomUtils.addChild((Element)transferReq, (String)"DebitCur", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
            Element requests = new Element("Requests");
            requests.setAttribute("noOfRecord", Integer.toString(paymentInfos.size()));
            block8: for (PaymentInfo paymentInfo : paymentInfos) {
                Element record = new Element("Record");
                Element fps = new Element("FasterPayment");
                JDomUtils.addChild((Element)record, (Element)fps);
                JDomUtils.addChild((Element)requests, (Element)record);
                if (!BOCHK_DC_Packer.isBelowZero(paymentInfo.getActualAmount())) {
                    JDomUtils.addChild((Element)fps, (String)"DebitAmt", (String)paymentInfo.getActualAmount().toString());
                } else {
                    JDomUtils.addChild((Element)fps, (String)"DebitAmt", (String)"");
                }
                String bankCode = paymentInfo.getPayeeBankCode();
                if (StringUtils.isNotEmpty((String)paymentInfo.getIncomeBankLocalClearingCode())) {
                    bankCode = paymentInfo.getIncomeBankLocalClearingCode();
                }
                JDomUtils.addChild((Element)fps, (String)"BeneBankCode", (String)bankCode);
                String incomeAcntNO = paymentInfo.getIncomeAccNo();
                if (!StringUtils.isEmpty((String)incomeAcntNO)) {
                    if (!StringUtils.isEmpty((String)bankCode) && bankCode.equals(incomeAcntNO.substring(0, 3))) {
                        incomeAcntNO = incomeAcntNO.substring(3);
                    }
                    JDomUtils.addChild((Element)fps, (String)"BeneAcctNo", (String)incomeAcntNO);
                }
                JDomUtils.addChild((Element)fps, (String)"BeneCountryCode", (String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"beneCountryCode"));
                JDomUtils.addChild((Element)fps, (String)"BeneTel", (String)paymentInfo.getMobiles());
                JDomUtils.addChild((Element)fps, (String)"BeneEmail", (String)paymentInfo.getEmails());
                JDomUtils.addChild((Element)fps, (String)"BeneFPSId", (String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"beneFPSId"));
                JDomUtils.addChild((Element)fps, (String)"BeneName", (String)paymentInfo.getIncomeAccName());
                JDomUtils.addChild((Element)fps, (String)"PaymentCur", (String)paymentInfo.getPayCurrency());
                JDomUtils.addChild((Element)fps, (String)"EquvAmt", (String)"");
                JDomUtils.addChild((Element)fps, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
                JDomUtils.addChild((Element)fps, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
                Element paymentdetail = JDomUtils.addChild((Element)fps, (String)"PaymentDetail");
                List<String> explanations = MultiLinesUtils.buildFPS(paymentInfo.getExplanation(), 5);
                for (String line : explanations) {
                    JDomUtils.addChild((Element)paymentdetail, (String)"Line", (String)line);
                }
                JDomUtils.addChild((Element)fps, (String)"CustRef", (String)paymentInfo.getBankDetailSeqId());
                JDomUtils.addChild((Element)fps, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate(paymentInfo.getBookingTime()));
                PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
                String isNotify = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"isNotify");
                if (!Boolean.parseBoolean(isNotify)) continue;
                JDomUtils.addChild((Element)fps, (String)"NotifyPayee", (String)"Y");
                String[] emails = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"beneEmail").split(";");
                for (int i = 0; i < emails.length; ++i) {
                    int num1 = i + 1;
                    String name = "NotifyEmail" + num1;
                    JDomUtils.addChild((Element)fps, (String)name, (String)emails[i]);
                    if (i == 5) continue block8;
                }
            }
            JDomUtils.addChild((Element)transferReq, (Element)requests);
            JDomUtils.addChild((Element)root, (Element)tx);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968", (String)"FastPayImpl_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BOCHK_DC_Parser.overseaParsePay(paymentInfos, s, "FasterPayment");
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return StringUtils.isNotEmpty((String)paymentInfo.getUseCN()) && BOCHK_DC_Constants.getFASTER_PAYMENT().equalsIgnoreCase(paymentInfo.getUseCN().trim());
    }
}

