/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.ins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsTransferEnquiry;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsUtils;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InsTeleTransfer
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InsTransferEnquiry.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        paymentInfo.setBankRefID(this.getBizCode());
        try {
            la.getToken();
            Element root = BOCHK_DC_Packer.createRootWithHead(paymentInfo.getPackageId());
            Element tx = new Element("Tx");
            Element InsTeleTransferREQ = JDomUtils.addChild((Element)tx, (String)"InsTeleTransferREQ");
            CountryISOCode payerCountry = InsUtils.getOrThrow(paymentInfo.getAccCountry(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u8d26\u6237\u56fd\u5bb6\u5730\u533a\u5fc5\u586b\u3002", (String)"InsTeleTransfer_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"DebitRegion", (String)payerCountry.geteChart2());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"DebitAcctNo", (String)paymentInfo.getAccNo());
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"DebitCur", (String)bankPayRequest.getAcnt().getCurrency());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"DebitAmt", (String)"");
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitAmt", (String)paymentInfo.getAmount().toPlainString());
            } else {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"DebitCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"DebitAmt", (String)paymentInfo.getAmount().toPlainString());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitAmt", (String)"");
            }
            if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargesOption", (String)"OUR");
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeAcctRegion", (String)payerCountry.geteChart2());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
            } else if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargesOption", (String)"BEN");
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeAcctRegion", (String)"");
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeAcctNo", (String)"");
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeCur", (String)"");
            } else {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargesOption", (String)"SHA");
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeAcctRegion", (String)payerCountry.geteChart2());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeAcctNo", (String)paymentInfo.getPayerFeeAccNo());
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ChargeCur", (String)paymentInfo.getPayerFeeCurrency());
            }
            CountryISOCode payeeCountry = InsUtils.getOrThrow(paymentInfo.getIncomeCountry(), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\u5730\u533a(incomeCountry)\u5fc5\u586b\u3002", (String)"InsTeleTransfer_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            String BeneBkInputmthd = "S";
            if ("CN".equalsIgnoreCase(payeeCountry.geteChart2()) && "CNY".equalsIgnoreCase(paymentInfo.getCurrency()) && StringUtils.isNotEmpty((String)paymentInfo.getIncomeCnaps())) {
                BeneBkInputmthd = "C";
            }
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneType", (String)"B");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneBkInputmthd", (String)BeneBkInputmthd);
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneCountryCode", (String)payeeCountry.geteChart2());
            boolean isNeedCNAP = "C".equalsIgnoreCase(BeneBkInputmthd);
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneBankerSwiftCode", (String)(isNeedCNAP ? "" : paymentInfo.getIncomeSwiftCode()));
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneBankerCountry", (String)payeeCountry.geteChart2());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneBankerCountryCodeWords", (String)paymentInfo.getIncomeBankCountryCodeWords());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneCityName", (String)paymentInfo.getIncomeCity());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"CnapsNum", (String)(isNeedCNAP ? paymentInfo.getIncomeSwiftCode() : ""));
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitBeneAcctNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitBeneName", (String)paymentInfo.getIncomeAccName());
            Element RemitBeneAddr = JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitBeneAddr");
            if ("HK".equalsIgnoreCase(payerCountry.geteChart2()) || "BN".equalsIgnoreCase(payerCountry.geteChart2()) || "MM".equalsIgnoreCase(payerCountry.geteChart2())) {
                JDomUtils.addChild((Element)RemitBeneAddr, (String)"Line", (String)"");
                JDomUtils.addChild((Element)RemitBeneAddr, (String)"Line", (String)"");
                JDomUtils.addChild((Element)RemitBeneAddr, (String)"Line", (String)"");
            } else {
                int payeeNameLen = MultiLinesUtils.computeLength(paymentInfo.getIncomeAccName());
                int limit = 133 - payeeNameLen;
                String payeeAddress = paymentInfo.getIncomeAddress();
                List<Object> addrLines = payeeNameLen > 35 && payeeNameLen < 71 ? InsUtils.splitBy(payeeAddress, Lists.newArrayList((Object[])new Integer[]{31, 32}), limit) : (payeeNameLen > 70 && payeeNameLen < 106 ? InsUtils.splitBy(payeeAddress, Lists.newArrayList((Object[])new Integer[]{28}), limit) : (payeeNameLen > 105 ? new ArrayList(0) : InsUtils.splitBy(payeeAddress, Lists.newArrayList((Object[])new Integer[]{31, 35, 32}), limit)));
                for (String addrLine : addrLines) {
                    JDomUtils.addChild((Element)RemitBeneAddr, (String)"Line", (String)addrLine);
                }
            }
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherBeneBankerRegion", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherBeneBankerBank", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherBeneBankerSwiftCode", (String)"");
            Element OtherBeneBankerAddr = JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherBeneBankerAddr");
            JDomUtils.addChild((Element)OtherBeneBankerAddr, (String)"Line", (String)"");
            JDomUtils.addChild((Element)OtherBeneBankerAddr, (String)"Line", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherBeneBankerCode", (String)"");
            String proxyAccNo = "";
            String hasCorr = "";
            String corrBeneBkIn = "";
            String corrBeneSwiftCode = "";
            if (StringUtils.isNotEmpty((String)paymentInfo.getProxyAccNo())) {
                proxyAccNo = paymentInfo.getProxyAccNo();
                hasCorr = "Y";
                corrBeneBkIn = "S";
                corrBeneSwiftCode = paymentInfo.getProxyBankSwiftCode();
            }
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"CorrBeneBkInputmthd", (String)corrBeneBkIn);
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"HasCorr", (String)hasCorr);
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"CorreBeneBankerAcct", (String)proxyAccNo);
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"CorreBeneBankerCountry", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"CorreBeneBankerSwiftCode", (String)corrBeneSwiftCode);
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherCorreBankerRegion", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherCorreBankerBank", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherCorreBeneBankerSwiftCode", (String)"");
            Element OtherCorreBankerAddr = JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherCorreBankerAddr");
            JDomUtils.addChild((Element)OtherCorreBankerAddr, (String)"Line", (String)"");
            JDomUtils.addChild((Element)OtherCorreBankerAddr, (String)"Line", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"OtherCorreBankerCode", (String)"");
            if ("MY".equalsIgnoreCase(payerCountry.geteChart2())) {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"PayPurpose", (String)"");
            } else {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"PayPurpose", (String)"E");
            }
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"PayPurposeOths1", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"PayPurposeOths2", (String)"");
            if ("VN".equalsIgnoreCase(payerCountry.geteChart2()) && ("VND".equalsIgnoreCase(bankPayRequest.getAcnt().getCurrency()) || "VND".equalsIgnoreCase(paymentInfo.getCurrency()))) {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ExchangePurpose", (String)"B1");
            } else {
                JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ExchangePurpose", (String)"");
            }
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ExchangePurposeSub", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ExchangePurposeOths", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitPurpose", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"RemitPurposeSub", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"MessageToBank", (String)"");
            Element PaymentDetail = JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"PaymentDetail");
            List<String> explanations = MultiLinesUtils.build(paymentInfo.getExplanation(), 4);
            for (String line : explanations) {
                JDomUtils.addChild((Element)PaymentDetail, (String)"Line", (String)line);
            }
            Element PaymentMemo = JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"PaymentMemo");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ApplicantName", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ApplicantPhoneNumber", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"GroupBusinessNumber", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"Priority", (String)"");
            if ("CN".equalsIgnoreCase(payerCountry.geteChart2())) {
                InsTeleTransferREQ.getChild("ApplicantName").setText(paymentInfo.getApplyName());
                InsTeleTransferREQ.getChild("ApplicantPhoneNumber").setText(paymentInfo.getApplyPhone());
                InsTeleTransferREQ.getChild("Priority").setText(paymentInfo.is2Urgent() ? "U" : "N");
            }
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"PurposeofRemittance", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransPayType", (String)"");
            if ("MY".equalsIgnoreCase(payerCountry.geteChart2())) {
                InsTeleTransferREQ.getChild("TransPayType").setText("F");
            }
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransCode1", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransAmount1", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransCurrency1", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransMemo1", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransCode2", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransAmount2", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransCurrency2", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"TransMemo2", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ContractNumber", (String)paymentInfo.getContractNo());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"InvoiceNumber", (String)paymentInfo.getInvoiceNo());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"IsBGDPay", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"WHBNumber", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"CustRef", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ExContract", (String)paymentInfo.getExContract());
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate(paymentInfo.getBookingTime()));
            Element Requests = JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"Requests");
            Requests.setAttribute("noOfRecord", "1");
            Element Record = JDomUtils.addChild((Element)Requests, (String)"Record");
            JDomUtils.addChild((Element)Record, (String)"SupplePackageId", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmailBit", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail1", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail2", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail3", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail4", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail5", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail6", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail7", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail8", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail9", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"BeneEmail10", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"CarbonToMyEmail", (String)"");
            JDomUtils.addChild((Element)InsTeleTransferREQ, (String)"GPIFlag", (String)"");
            JDomUtils.addChild((Element)root, (Element)tx);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968", (String)"TeleTransferPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        InsUtils.parsePay(paymentInfos, s, "InsTeleTransferRLY");
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "InsTeleTransfer";
    }

    public String getBizDesc() {
        return BOCHK_DC_Constants.InsTT();
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BOCHK_DC_Constants.InsTT().equalsIgnoreCase(paymentInfo.getUseCN()) || paymentInfo.getUseCN().startsWith(this.getBizCode());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

