/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.payment.ins;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BOCHK_DC_Constants;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsTransferEnquiry;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ins.InsUtils;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccess;
import kd.ebg.aqap.banks.bochk.dc.services.payment.ticket.PayLoginAccessManager;
import kd.ebg.aqap.banks.bochk.dc.utils.MultiLinesUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InsTransfer
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InsTransferEnquiry.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        paymentInfo.setBankRefID(this.getBizCode());
        try {
            la.getToken();
            Element root = BOCHK_DC_Packer.createRootWithHead(paymentInfo.getPackageId());
            Element tx = new Element("Tx");
            Element insTransferREQ = JDomUtils.addChild((Element)tx, (String)"InsTransferREQ");
            CountryISOCode payerCountry = InsUtils.getOrThrow(paymentInfo.getAccCountry(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u8d26\u6237\u56fd\u5bb6\u5730\u533a\u5fc5\u586b\u3002", (String)"InsTeleTransfer_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            JDomUtils.addChild((Element)insTransferREQ, (String)"DebitRegion", (String)payerCountry.geteChart2());
            JDomUtils.addChild((Element)insTransferREQ, (String)"DebitAcctNo", (String)paymentInfo.getAccNo());
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)insTransferREQ, (String)"DebitCur", (String)bankPayRequest.getAcnt().getCurrency());
                JDomUtils.addChild((Element)insTransferREQ, (String)"DebitAmt", (String)"");
            } else {
                JDomUtils.addChild((Element)insTransferREQ, (String)"DebitCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)insTransferREQ, (String)"DebitAmt", (String)paymentInfo.getAmount().toPlainString());
            }
            JDomUtils.addChild((Element)insTransferREQ, (String)"BeneType", (String)"B");
            JDomUtils.addChild((Element)insTransferREQ, (String)"BeneRegion", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"BeneAcctNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)insTransferREQ, (String)"BeneAcctName", (String)paymentInfo.getIncomeAccName());
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)insTransferREQ, (String)"PaymentCur", (String)paymentInfo.getCurrency());
                JDomUtils.addChild((Element)insTransferREQ, (String)"EquvAmt", (String)paymentInfo.getAmount().toPlainString());
            } else {
                JDomUtils.addChild((Element)insTransferREQ, (String)"PaymentCur", (String)"");
                JDomUtils.addChild((Element)insTransferREQ, (String)"EquvAmt", (String)"");
            }
            JDomUtils.addChild((Element)insTransferREQ, (String)"PayPurposeCode", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"ExchangeFundSource", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"ExchangePurposeSub", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"ExchangeFundSourceOths", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"RemitPurpose", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"RemitPurposeSub", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"PaymentType", (String)"");
            JDomUtils.addChild((Element)insTransferREQ, (String)"Priority", (String)"");
            Element MsgToBene = JDomUtils.addChild((Element)insTransferREQ, (String)"MsgToBene");
            List<String> lines = MultiLinesUtils.build(paymentInfo.getExplanation(), 2);
            for (String line : lines) {
                JDomUtils.addChild((Element)MsgToBene, (String)"Line", (String)line);
            }
            Element PaymentMemo = JDomUtils.addChild((Element)insTransferREQ, (String)"PaymentMemo");
            for (int i = 0; i < 5; ++i) {
                JDomUtils.addChild((Element)PaymentMemo, (String)"Line", (String)"");
            }
            JDomUtils.addChild((Element)insTransferREQ, (String)"CustRef", (String)"");
            if (paymentInfo.isDiffCurrency()) {
                JDomUtils.addChild((Element)insTransferREQ, (String)"ExContract", (String)paymentInfo.getContractNo());
            } else {
                JDomUtils.addChild((Element)insTransferREQ, (String)"ExContract", (String)"");
            }
            JDomUtils.addChild((Element)insTransferREQ, (String)"ValueDate", (String)BOCHK_DC_Packer.valueDate(paymentInfo.getBookingTime()));
            Element requests = JDomUtils.addChild((Element)insTransferREQ, (String)"Requests");
            requests.setAttribute("noOfRecord", "1");
            Element record = JDomUtils.addChild((Element)requests, (String)"Record");
            JDomUtils.addChild((Element)record, (String)"BeneEmailBit", (String)"N");
            JDomUtils.addChild((Element)record, (String)"SiControlBit", (String)"");
            JDomUtils.addChild((Element)root, (Element)tx);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968", (String)"TeleTransferPayImpl_0", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        InsUtils.parsePay(paymentInfos, s, "InsTransferRLY");
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "InsTransfer";
    }

    public String getBizDesc() {
        return BOCHK_DC_Constants.InsTransfer();
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BOCHK_DC_Constants.InsTransfer().equalsIgnoreCase(paymentInfo.getUseCN()) || paymentInfo.getUseCN().startsWith(this.getBizCode());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }
}

