/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.global.service.login;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ebg.aqap.banks.boc.net.global.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginImpl;
import kd.ebg.egf.common.log.EBGLogger;

public class LoginAccess {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(LoginAccess.class);
    private long interval = 5000L;
    private String key;
    private LoginImpl impl;
    private AtomicInteger currentCount = new AtomicInteger(0);
    private Semaphore semaphore;
    private int maxPermit;

    public LoginAccess(String key) {
        this.impl = new LoginImpl();
        this.key = key;
        log.info(key + ":" + this.interval + "(ms).");
        this.maxPermit = BankBusinessConfig.has5sInterval() ? 1 : 5;
    }

    public String getKey() {
        return this.key;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public synchronized String getToken() {
        String token = this.impl.getToken();
        return token;
    }

    public synchronized void checkTokenValid(String rspCode) {
        if ("B107".equalsIgnoreCase(rspCode) || "1033".equalsIgnoreCase(rspCode)) {
            this.impl.setTokenInvalid();
        }
    }

    public void unavailableRelease() {
        if (BankBusinessConfig.has5sInterval()) {
            this.sleepQuietly();
        }
    }

    private void sleepQuietly() {
        try {
            log.info("\u5f00\u59cb sleep 5\u79d2");
            Thread.sleep(this.interval);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

