/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment.otherbank.batch.together;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankBatchTogetherQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OtherBankBatchTogetherQueryPayImpl.class);
    private static final String transCode = "303223";

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(transCode, "0"));
        String cms_corp_no = RequestContextUtils.getParameter().getBankParameter("cms_corp_no");
        Element body = new Element("body");
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        String time = paymentInfos[0].getRequestTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        if (cms_corp_no != null) {
            JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)cms_corp_no);
        } else {
            JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)time);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(requestMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        Element body = bank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankBatchTogetherQueryPayImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        String content = null;
        if (recordNum <= 0) {
            this.logger.error("###\u672c\u6b21\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"OtherBankBatchTogetherQueryPayImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            return new EBBankPayResponse(paymentInfos);
        }
        if ("0".equals(head.getChildTextTrim("file_flag"))) {
            String serial_record;
            content = serial_record = body.getChildTextTrim("serial_record");
        } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
            String file_name = body.getChildTextTrim("file_name");
            content = IOUtils.downloadFileFromLocal(file_name);
        }
        String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
        OtherBankBatchTogetherQueryPayImpl.parsepayInfo(bankPayRequest.getPaymentInfoAsArray(), rs);
        return new EBBankPayResponse(paymentInfos);
    }

    private static void parsepayInfo(PaymentInfo[] paymentInfos, String[][] rs) {
        for (int i = 0; i < rs.length; ++i) {
            String accnbr = rs[i][5];
            String trsamt = rs[i][10];
            String TransStatus = rs[i][3];
            if (StringUtils.isEmpty((String)trsamt)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u90a2\u53f0\u94f6\u884c\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u91d1\u989dTRSAMT \u4e3a\u7a7a", (String)"OtherBankBatchTogetherQueryPayImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            }
            BigDecimal amount = new BigDecimal(trsamt.trim());
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)accnbr, (BigDecimal)(amount = amount.setScale(2)));
            if (null == paymentInfo) continue;
            if ("0".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"OtherBankBatchTogetherQueryPayImpl_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)TransStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"OtherBankBatchTogetherQueryPayImpl_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("1".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"OtherBankBatchTogetherQueryPayImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)TransStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"OtherBankBatchTogetherQueryPayImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankBatchTogetherQueryPayImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)TransStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"OtherBankBatchTogetherQueryPayImpl_5", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return transCode;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7edf\u4e00\u652f\u4ed8\u8de8\u884c\u6279\u91cf\u4ee3\u6263\u7ed3\u679c", (String)"OtherBankBatchTogetherQueryPayImpl_6", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }
}

