/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.reservefund.ReserveFundConfigInfo;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.BusTypeUtils;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseConvertor {
    private static Logger logger = LoggerFactory.getLogger(UseConvertor.class);

    public static String convert2ICBCUseCn(PaymentInfo paymentInfo, String interfaceCode) {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getExplanation();
        if (StringUtils.isEmpty((String)useCode) || "-1".equalsIgnoreCase(useCode)) {
            if (paymentInfo.getIndividual().booleanValue()) {
                String customId = EBContext.getContext().getCustomID();
                String interfaceName = interfaceCode;
                String bankVersion = "ICBC_CMP";
                useCode = UseKeyWordService.getUseByKey((String)customId, (String)useCn, (String)interfaceName, (String)paymentInfo.getUseCN(), (String)bankVersion);
                return useCode;
            }
            logger.info("\u5f00\u53d1\u9519\u8bef\uff0c\u4e0d\u662f\u4f01\u4e1a\u8d22\u52a1\u5ba4\u6307\u4ee4\u6c47\u603b\u63d0\u4ea4\uff0c\u4e0d\u9700\u8981\u8f6c\u6362\u4e3a\u4f01\u4e1a\u8d22\u52a1\u5ba4\u6307\u4ee4\u7684\u4ed8\u6b3e\u7528\u9014");
            return paymentInfo.getUseCN();
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u7801%s\u3002", (String)"UseConvertor_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    public static String convert2ICBCBusType(PaymentInfo paymentInfo) {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getUseCN();
        if (StringUtils.isEmpty((String)useCode) || "-1".equalsIgnoreCase(useCode)) {
            if (paymentInfo.getIndividual().booleanValue()) {
                BusTypeUtils busTypeUtils = BusTypeUtils.getInstance();
                return BusTypeUtils.busTypeMap.get(useCn);
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f00\u53d1\u9519\u8bef\uff0c\u4e0d\u662f\u4f01\u4e1a\u8d22\u52a1\u5ba4\u6307\u4ee4\u6c47\u603b\u63d0\u4ea4\uff0c\u4e0d\u9700\u8981\u8f6c\u6362\u4e3a\u4e1a\u52a1\u79cd\u7c7b\u7f16\u53f7\u3002", (String)"UseConvertor_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u7801%s\u3002", (String)"UseConvertor_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), paymentInfo.getUseCode()));
    }

    public static Map<String, ReserveFundConfigInfo> getReserveFundConfig(String reserveFundAccountPool) {
        String[] split;
        HashMap<String, ReserveFundConfigInfo> reserveFundConfigMap = new HashMap<String, ReserveFundConfigInfo>();
        for (String configInfos : split = reserveFundAccountPool.split(";")) {
            String[] config = configInfos.split(",");
            ReserveFundConfigInfo reserveFundConfigInfo = new ReserveFundConfigInfo();
            reserveFundConfigInfo.setBakAccount(config[0]);
            reserveFundConfigInfo.setAcctType(config[1]);
            reserveFundConfigInfo.setCashPro(config[2]);
            reserveFundConfigInfo.setFZCode(config[3]);
            reserveFundConfigInfo.setInCashPro(config[4]);
            reserveFundConfigInfo.setPosNo(config[5]);
            reserveFundConfigMap.put(config[0], reserveFundConfigInfo);
        }
        return reserveFundConfigMap;
    }
}

