/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.allocation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.ICBC_CMP_FailErrorCodes;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    private static final String transCode = "GCOLDIS";

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return transCode;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u300a\u5168\u7403\u5f52\u96c6\u4e0b\u62e8\u6307\u4ee4\u63d0\u4ea4.xls\u300b\u548c\u300a\u5168\u7403\u5f52\u96c6\u4e0b\u62e8\u6307\u4ee4\u67e5\u8be2.xls\u300b\u5df2\u63d0\u4ea4\uff1b\u4ea4\u6613\u7801\u5206\u522b\u4e3aGCOLDIS\u548cGQCOLDIS\u3002", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isLoanAccountPool(paymentInfo.getAccNo(), paymentInfo.getIncomeAccNo());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(transCode, info.getBankBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BankType", (String)"102");
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)in, (String)"MemberAccNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)in, (String)"CurrType", (String)info.getCurrency());
        JDomUtils.addChild((Element)in, (String)"ColDisAmt", (String)PackerUtils.convertYuan2CentStr((BigDecimal)info.getAmount()));
        JDomUtils.addChild((Element)in, (String)"ColDisType", (String)"1");
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]).equalsIgnoreCase(info.getUseCN())) {
            JDomUtils.addChild((Element)in, (String)"ColDisFlag", (String)"2");
        } else if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"AllocationPayImpl_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]).equalsIgnoreCase(info.getUseCN())) {
            JDomUtils.addChild((Element)in, (String)"ColDisFlag", (String)"1");
        } else {
            JDomUtils.addChild((Element)in, (String)"ColDisFlag", (String)"5");
        }
        JDomUtils.addChild((Element)in, (String)"InterAcctNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"DayCalFlag", (String)"1");
        String allocationNo = BankBusinessConfig.getAllocationNo(info.getAccNo());
        if (StrUtil.isEmpty((String)allocationNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u627e\u8d26\u53f7\uff1a%s\u914d\u7f6e\u7684\u59d4\u8d37\u534f\u8bae\u53f7\uff0c\u8bf7\u5728\u8d26\u6237\u7ba1\u7406\u9644\u4ef6\u5c5e\u6027\u91cc\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"AllocationPayImpl_7", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), info.getAccNo()));
        }
        JDomUtils.addChild((Element)in, (String)"AgreeNo", (String)allocationNo);
        JDomUtils.addChild((Element)in, (String)"MainAcctNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"RtclsFlag", (String)"1");
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        boolean isProduct = StrUtil.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"))));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)info.getCurrency());
        JDomUtils.addChild((Element)in, (String)"MainAccNoCur", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg, request.getPaymentInfos());
        return ICBC_CMP_Packer.createMessageWithHeadForPay(msgSigned, transCode, "0.0.1.0", 0, info.getBankBatchSeqId());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        String simplifyRspCode4Cpic = EBContext.getContext().getParameter().getBankParameter("simplifyRspCode4Cpic");
        boolean cpic = "true".equalsIgnoreCase(simplifyRspCode4Cpic);
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String fSeqno = pub.getChildText("fSeqno");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "";
        bankStatus = cpic ? headRsp.getResponseCode() : "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            if (ICBC_CMP_FailErrorCodes.isFailed(headRsp.getResponseCode()) || "D0089".equals(headRsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            }
            return new EBBankPayResponse(paymentInfos);
        }
        Element out = eb.getChild("out");
        if (null == out) {
            if (0 != paymentInfos.size()) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5de5\u884c\u63a5\u6536\u4e86\u6279\u91cf\u4ed8\u6b3e\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\u3002", (String)"AllocationPayImpl_5", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                return new EBBankPayResponse(paymentInfos);
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        String result = JDomUtils.getChildText((Element)out, (String)"Result");
        if ("7".equalsIgnoreCase(result)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        } else if ("6".equalsIgnoreCase(result) || "8".equalsIgnoreCase(result)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            if ("B0083".equalsIgnoreCase(headRsp.getResponseCode())) {
                paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u94f6\u4f01\u4e2d\u95f4\u4ef6\u5efa\u8bae\u60a8\u68c0\u67e5\u6536\u6b3e\u8d26\u53f7,\u4ed8\u6b3e\u5931\u8d25\u7684\u539f\u56e0\u53ef\u80fd\u662f:\u5de5\u884c\u7684\u540c\u884c\u652f\u4ed8\u65f6,\u6536\u6b3e\u8d26\u53f7\u586b\u5199\u9519\u8bef", (String)"AllocationPayImpl_6", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

