/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.reservefund;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_PayParser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.UseConvertor;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.reservefund.QueryReserveFundPayment;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.reservefund.ReserveFundConfigInfo;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ReserveFundPayment
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryReserveFundPayment.class;
    }

    public String pack(BankPayRequest request) {
        BigDecimal totalAmt = new BigDecimal("0.00");
        List paymentInfos = request.getPaymentInfos();
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(this.getBizCode(), ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)in, (String)"TotalAmt", (String)"");
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        boolean isProduct = StrUtil.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"))));
        }
        Map<String, ReserveFundConfigInfo> reserveFundConfig = UseConvertor.getReserveFundConfig(BankBusinessConfig.getReserveFundAccountPool());
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
            totalAmt = totalAmt.add(info.getAmount());
            Element rd = JDomUtils.addChild((Element)in, (String)"rd");
            ReserveFundConfigInfo reserveFundConfigInfo = reserveFundConfig.get(info.getIncomeAccNo());
            JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)info.getBankSerialNo());
            JDomUtils.addChild((Element)rd, (String)"PayAccount", (String)info.getAccNo());
            JDomUtils.addChild((Element)rd, (String)"PayAcctName", (String)info.getAccName());
            JDomUtils.addChild((Element)rd, (String)"RecAccount", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)rd, (String)"RecAcctName", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)rd, (String)"CurrType", (String)info.getCurrency());
            JDomUtils.addChild((Element)rd, (String)"CashBill", (String)"1");
            JDomUtils.addChild((Element)rd, (String)"Amount", (String)PackerUtils.convertYuan2CentStr((BigDecimal)info.getAmount()));
            JDomUtils.addChild((Element)rd, (String)"Remark", (String)info.getExplanation());
            JDomUtils.addChild((Element)rd, (String)"PayType", (String)(info.is2Merge() ? "1" : "0"));
            if (reserveFundConfigInfo == null) {
                JDomUtils.addChild((Element)rd, (String)"AcctType", (String)"");
                JDomUtils.addChild((Element)rd, (String)"BakAccount", (String)"");
                JDomUtils.addChild((Element)rd, (String)"CashPro", (String)"");
                JDomUtils.addChild((Element)rd, (String)"FZCode", (String)"");
                JDomUtils.addChild((Element)rd, (String)"InCashPro", (String)"");
                JDomUtils.addChild((Element)rd, (String)"PosNo", (String)"");
                continue;
            }
            JDomUtils.addChild((Element)rd, (String)"AcctType", (String)reserveFundConfigInfo.getAcctType());
            JDomUtils.addChild((Element)rd, (String)"BakAccount", (String)reserveFundConfigInfo.getBakAccount());
            JDomUtils.addChild((Element)rd, (String)"CashPro", (String)reserveFundConfigInfo.getCashPro());
            JDomUtils.addChild((Element)rd, (String)"FZCode", (String)reserveFundConfigInfo.getFZCode());
            JDomUtils.addChild((Element)rd, (String)"InCashPro", (String)reserveFundConfigInfo.getCashPro());
            JDomUtils.addChild((Element)rd, (String)"PosNo", (String)reserveFundConfigInfo.getPosNo());
        }
        in.getChild("TotalAmt").setText(PackerUtils.convertYuan2CentStr((BigDecimal)totalAmt));
        String encoding = context.getCharsetName();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg, request.getPaymentInfos());
        return ICBC_CMP_Packer.createMessageWithHeadForPay(msgSigned, this.getBizCode(), "0.0.0.1", 0, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        ICBC_CMP_PayParser.parsePayNew(bankPayRequest.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DJGSHK";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5907\u7528\u91d1\u4ed8\u6b3e", (String)"ReserveFundPayment_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

