/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.payment.company;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.CommonPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Content;
import org.jdom2.Element;

public class CompanyPayImpl
extends CommonPayImpl
implements INativeLinkPayable {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CompanyPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSET35";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !paymentInfo.is2Individual();
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String kdFlag = PaymentUtils.getKD(paymentInfo);
        LoginUtils.login(this.logger);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSET35", Sequence.genSequence());
        root.addContent((Content)headr);
        Element req = CommonPacker.packComEntity("00000882", paymentInfo.getBankBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData(req, "CstPty_Py_Jrnl_No", kdFlag);
        JDomExtUtils.addChildCDData(req, "Pyr_BkCgyCd", "01");
        JDomExtUtils.addChildCDData(req, "Pyr_Cst_AccNo", paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData(req, "Pyr_AccNm", paymentInfo.getAccName());
        JDomExtUtils.addChildCDData(req, "Pyr_Acc_CgyCd", "02");
        JDomExtUtils.addChildCDData(req, "RcvPrt_BkCgyCd", paymentInfo.is2SameBank() ? "01" : "02");
        JDomExtUtils.addChildCDData(req, "RcvPrt_Cst_AccNo", paymentInfo.getIncomeAccNo());
        JDomExtUtils.addChildCDData(req, "RcvPrt_DpBkNm", paymentInfo.getIncomeBankName());
        JDomExtUtils.addChildCDData(req, "RcvPtAc_Nm", paymentInfo.getIncomeAccName());
        JDomExtUtils.addChildCDData(req, "RcvPrt_BnkCD", paymentInfo.getIncomeCnaps());
        JDomExtUtils.addChildCDData(req, "RcvPrt_Adr", paymentInfo.getIncomeBankAddress());
        JDomExtUtils.addChildCDData(req, "Rmrk", paymentInfo.getExplanation());
        JDomExtUtils.addChildCDData(req, "Py_Cnd_TpCd", "00");
        JDomExtUtils.addChildCDData(req, "RvPy_ExMd_Cd", "0");
        JDomExtUtils.addChildCDData(req, "Cst_Dlv_Dt", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(req, "Cst_Dlv_Tm", LocalDateTime.now().format(DateTimeFormatter.ofPattern("hhmmssSSS")));
        JDomExtUtils.addChildCDData(req, "Rqs_Amt", paymentInfo.getAmount().toString());
        JDomExtUtils.addChildCDData(req, "Urgnt_TpCd", paymentInfo.is2Urgent() ? "02" : "01");
        if ("pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            JDomExtUtils.addChildCDData(req, "Use_Nm", ResManager.loadKDString((String)"\u5185\u90e8\u8d44\u91d1\u8c03\u62e8", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
        }
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List paymentInfos = request.getPaymentInfos();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        Element head = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String headCode = JDomExtUtils.getChildText((Element)head, (String)"SYS_TX_STATUS");
        String resultCode = "";
        String bankMsg = "";
        String bankCode = "";
        if (null != response) {
            resultCode = JDomExtUtils.getChildText((Element)response, (String)"CshMgt_Txn_Rslt_Cd");
            bankMsg = JDomExtUtils.getChildText((Element)response, (String)"Err_Inf");
            bankCode = JDomExtUtils.getChildText((Element)response, (String)"CshMgt_Err_Cd");
        } else {
            bankMsg = bankResp.getBankMsg();
            bankCode = bankResp.getResponseCode();
        }
        if ("00".equalsIgnoreCase(headCode)) {
            if ("1".equalsIgnoreCase(resultCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
            } else if ("2".equalsIgnoreCase(resultCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankCode, (String)bankMsg);
            } else if ("3".equalsIgnoreCase(resultCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankCode, (String)bankMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5,resultCode=%s", (String)"CompanyPayImpl_6", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), resultCode), (String)bankCode, (String)bankMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5,headCode=%s", (String)"CompanyPayImpl_7", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), headCode), (String)bankCode, (String)bankMsg);
        }
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }
}

