/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.balace;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }

    public String getDeveloper() {
        return "HSQ";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest req) {
        BankAcnt bankAcnt = req.getAcnt();
        JsonObject body = new JsonObject();
        body.addProperty("accountNo", bankAcnt.getAccNo());
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109001", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest req, String rspStr) {
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        String retMsgDecoded = rspStr;
        BankResponse rsp = XMB_Parser.paseHeadRoot(retMsgDecoded);
        logger.info("\u94f6\u884c\u8fd4\u56de\u7801\u4e3a" + rsp.getResponseCode() + "\uff0c\u89e3\u6790\u4f59\u989d\u6210\u529f\uff01");
        if (!"000000".equalsIgnoreCase(rsp.getResponseCode()) && !"00000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s\uff1b\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        BalanceInfo balanceInfo = this.getBalance(req, rspStr);
        logger.info("\u94f6\u884c\u8fd4\u56de\u7801\u4e3a" + rsp.getResponseCode() + "\uff0c\u89e3\u6790\u4f59\u989d\u6210\u529f\uff01");
        bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return bankBalanceResponse;
    }

    private BalanceInfo getBalance(BankBalanceRequest req, String rspStr) throws EBServiceException {
        BalanceInfo balanceInfo = new BalanceInfo();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(rspStr).getAsJsonObject();
        JsonObject body = jsonObject.get("body").getAsJsonObject();
        String availableBalance = body.get("onlineActualBal").getAsString();
        String currentBalance = body.get("acctBal").getAsString();
        this.setBankAcnt(balanceInfo, req.getAcnt());
        this.setAvailableBalance(balanceInfo, availableBalance);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setBankCurrency(balanceInfo, req.getBankCurrency());
        this.setCurrentBalance(balanceInfo, currentBalance);
        return balanceInfo;
    }
}

