/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.detail;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.service.detail.DetailPage;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailPageImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        try {
            DetailPage page = new DetailPage();
            String pageTag = page.getFirstPageTag();
            String rspStr = null;
            String bizSeqId = request.getHeader().getBizSeqID();
            do {
                String rqstStr = this.packHisDetail(request, pageTag);
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection conn = this.getConnection(factory);
                this.openConnection(conn);
                try (OutputStream os = this.getOutputStream(conn);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream(conn);){
                        rspStr = this.recv(is);
                        detailList.addAll(this.parseHisDetail(request, rspStr));
                        pageTag = page.getNextPageTag(rspStr, pageTag);
                    }
                }
            } while (!page.isLastPage(rspStr, pageTag));
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String packHisDetail(BankDetailRequest bdr, String pageTag) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        LocalDate startDate = bdr.getStartDate();
        JsonObject body = new JsonObject();
        body.addProperty("accountNo", bdr.getAcnt().getAccNo());
        body.addProperty("startDate", DateUtil.formatDate((LocalDate)startDate, (String)"yyyyMMdd"));
        body.addProperty("endDate", DateUtil.formatDate((LocalDate)bdr.getEndDate(), (String)"yyyyMMdd"));
        logger.info("\u5f53\u524d\u9875\u9762\uff1a" + Integer.parseInt(pageTag));
        body.addProperty("pageNo", (Number)Integer.parseInt(pageTag));
        body.addProperty("pageSize", (Number)10);
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109013", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        BankAcnt bankAcnt = rqst.getAcnt();
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        String retMsgDecoded = rspStr;
        BankResponse rsp = XMB_Parser.paseHeadRoot(retMsgDecoded);
        if ("000000".equalsIgnoreCase(rsp.getResponseCode()) || "00000".equalsIgnoreCase(rsp.getResponseCode())) {
            return this.getDetailList(retMsgDecoded, bankAcnt);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s\uff1b\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"DetailPageImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
    }

    private List<DetailInfo> getDetailList(String retMsgDecoded, BankAcnt bankAcnt) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        retMsgDecoded = retMsgDecoded.replace("null", "\"\"");
        logger.info(retMsgDecoded);
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(retMsgDecoded).getAsJsonObject();
        JsonObject body = jsonObject.get("body").getAsJsonObject();
        int totalRecord = body.get("totalRecord").getAsInt();
        if (totalRecord > 0) {
            JsonArray acctTranDetailList = body.get("acctTranDetailList").getAsJsonArray();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
            for (int i = 0; i < acctTranDetailList.size(); ++i) {
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setAccNo(bankAcnt.getAccNo());
                detailInfo.setAccName(bankAcnt.getAccName());
                JsonObject acctTranDetail = acctTranDetailList.get(i).getAsJsonObject();
                String tranDateStr = acctTranDetail.get("tranDate").getAsString();
                String tranTimeStr = acctTranDetail.get("tranTime").getAsString();
                if (StringUtils.isEmpty((String)tranTimeStr)) {
                    tranTimeStr = "000000";
                }
                String date = tranDateStr + tranTimeStr;
                try {
                    detailInfo.setTransTime(LocalDateTime.parse(date, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                    detailInfo.setTransDate(LocalDate.parse(tranDateStr, DateTimeFormatter.ofPattern("yyyyMMdd")));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9\uff01", (String)"DetailPageImpl_2", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (Throwable)e);
                }
                String currency = acctTranDetail.get("currency").getAsString();
                detailInfo.setCurrency(currency);
                BigDecimal creditAmt = acctTranDetail.get("creditAmt").getAsBigDecimal();
                BigDecimal debitAmt = acctTranDetail.get("debitAmt").getAsBigDecimal();
                detailInfo.setCreditAmount(debitAmt);
                detailInfo.setDebitAmount(creditAmt);
                BigDecimal closingBal = acctTranDetail.get("closingBal").getAsBigDecimal();
                detailInfo.setBalance(closingBal);
                String remarks = acctTranDetail.get("remarks").getAsString();
                detailInfo.setUseCn(remarks);
                detailInfo.setTransType("remarks");
                String cbsToAcctNo = acctTranDetail.get("cbsToAcctNo").getAsString();
                detailInfo.setOppAccName(cbsToAcctNo);
                String cbsToAcctName = acctTranDetail.get("cbsToAcctName").getAsString();
                detailInfo.setOppAccName(cbsToAcctName);
                String cbsToAcctBranchNm = acctTranDetail.get("cbsToAcctBranchNm").getAsString();
                detailInfo.setOppBankName(cbsToAcctBranchNm);
                detailInfo.setHistory(Boolean.valueOf(true));
                detailList.add(detailInfo);
            }
        }
        return detailList;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

