/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.payment.pay;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.banks.xib.dc.service.payment.QueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class OtherPaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        String result = "";
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        result = this.getJsonFromNotSameBank(paymentInfo);
        return result;
    }

    private String getJsonFromNotSameBank(PaymentInfo paymentInfo) throws EBServiceException {
        JsonObject body = new JsonObject();
        body.addProperty("transId", paymentInfo.getBankDetailSeqID());
        body.addProperty("accountNo", paymentInfo.getAccNo());
        body.addProperty("debitAcctName", paymentInfo.getAccName());
        body.addProperty("creditAcctNo", paymentInfo.getIncomeAccNo());
        body.addProperty("creditAcctName", paymentInfo.getIncomeAccName());
        body.addProperty("receiveBankNo", paymentInfo.getIncomeCnaps());
        body.addProperty("receiveBankName", paymentInfo.getIncomeBankName());
        body.addProperty("amount", paymentInfo.getAmount() + "");
        body.addProperty("currency", "CNY");
        String exp = paymentInfo.getExplanation();
        body.addProperty("paymentUsage", exp);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            exp = exp + "KD@" + paymentInfo.getBankDetailSeqID();
        }
        body.addProperty("addtlInf", exp);
        if (paymentInfo.is2Urgent() || paymentInfo.getAmount() != null && paymentInfo.getAmount().compareTo(new BigDecimal(50000)) > 0) {
            body.addProperty("transType", (Number)2);
        } else {
            body.addProperty("transType", (Number)1);
        }
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109006", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        String retMsgDecoded = rspStr;
        BankResponse rsp = XMB_Parser.paseHeadRoot(retMsgDecoded);
        if ("00000".equalsIgnoreCase(rsp.getResponseCode())) {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse(retMsgDecoded).getAsJsonObject();
            JsonObject body = jsonObject.get("body").getAsJsonObject();
            int transStatus = body.get("transStatus").getAsInt();
            if (transStatus == 0) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)String.valueOf(transStatus), (String)rsp.getResponseMessage());
            } else if (transStatus == 1) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)String.valueOf(transStatus), (String)rsp.getResponseMessage());
            } else if (transStatus == 2) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)String.valueOf(transStatus), (String)rsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)String.valueOf(transStatus), (String)rsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(Arrays.asList(paymentInfos));
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String getDeveloper() {
        return "HSQ";
    }

    public String getBizCode() {
        return "IESI109009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26\uff08IESI109009\uff09\uff0c\u540c\u884c\u8f6c\u8d26\uff08IESI109005\uff09", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }
}

