/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.payment.salary;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }

    public int getBatchSize() {
        return 50;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JsonObject body = new JsonObject();
        body.addProperty("batchNo", ((PaymentInfo)paymentInfos.get(0)).getBatchSeqId());
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109011", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse rsp = XMB_Parser.paseHeadRoot(s);
        String responseCode = rsp.getResponseCode();
        String responseMessage = rsp.getResponseMessage();
        if ("00000".equalsIgnoreCase(responseCode) || "000000".equals(rsp.getResponseCode())) {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse(s).getAsJsonObject();
            JsonObject body = jsonObject.get("body").getAsJsonObject();
            JsonArray transStatusList = body.get("transStatusList").getAsJsonArray();
            for (int i = 0; i < transStatusList.size(); ++i) {
                String errMsg;
                JsonObject transStatusObject = transStatusList.get(i).getAsJsonObject();
                String transId = transStatusObject.get("transId").getAsString();
                PaymentInfo curPayInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)transId);
                if (null == curPayInfo) continue;
                int transStatus = transStatusObject.get("transStatus").getAsInt();
                String errCode = body.get("errCode") == null ? rsp.getResponseCode() : body.get("errCode").getAsString();
                String string = errMsg = body.get("errMsg") == null ? rsp.getResponseMessage() : body.get("errMsg").getAsString();
                if (transStatus == 0) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)curPayInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryImpl_0", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)responseMessage);
                    continue;
                }
                if (transStatus == 2) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)curPayInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryImpl_1", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)(responseMessage + "||" + errMsg));
                    continue;
                }
                if (transStatus == 1) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)curPayInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryImpl_2", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)(responseMessage + "||" + errMsg));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)curPayInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)errCode, (String)(responseMessage + "||" + errMsg));
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMessage);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "IESI109008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"5.8\u8f6c\u8d26\u72b6\u6001\u67e5\u8be2(IESI109008)", (String)"QueryImpl_4", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }
}

