/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsurb.dc.services.payment;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsurb.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.SignUtils;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TPacker;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"HttpUri"));
        factory.setHttpHeader("content-type", "text/xml; charset=" + RequestContextUtils.getCharset());
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos == null || paymentInfos.isEmpty()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e3a\u7a7a\uff01", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        }
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        }
        String cid = RequestContextUtils.getBankParameterValue((String)"CustomerId");
        String branchId = RequestContextUtils.getBankParameterValue((String)"BranchId");
        String d = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String tr_code = "CBE003";
        if (!paymentInfo.is2SameBank()) {
            tr_code = "CBE004";
        }
        Element QLBankData = TPacker.createCommonHead(tr_code, cid, paymentInfo.getPackageId(), d);
        Element opReq = QLBankData.getChild("opReq");
        Element ReqParam = opReq.getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"serialNo", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)ReqParam, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"payAccountName", (String)paymentInfo.getAccName());
        if (!paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)ReqParam, (String)"fastFlg", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        }
        JDomUtils.addChild((Element)ReqParam, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        if (!paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)ReqParam, (String)"recBankCode", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)ReqParam, (String)"recBankName", (String)paymentInfo.getIncomeBankName());
        }
        String amount = paymentInfo.getAmount().setScale(2, 1).toPlainString();
        JDomUtils.addChild((Element)ReqParam, (String)"tranAmt", (String)amount);
        JDomUtils.addChild((Element)ReqParam, (String)"payUse", (String)paymentInfo.getUseCn());
        JDomUtils.addChild((Element)ReqParam, (String)"remark", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)ReqParam, (String)"branchId", (String)branchId);
        String str = "";
        str = paymentInfo.is2SameBank() ? paymentInfo.getAccNo() + "|" + paymentInfo.getAccName() + "|" + paymentInfo.getIncomeAccNo() + "|" + paymentInfo.getIncomeAccName() + "|" + amount : paymentInfo.getAccNo() + "|" + paymentInfo.getAccName() + "|" + paymentInfo.getIncomeAccNo() + "|" + paymentInfo.getIncomeAccName() + "|" + paymentInfo.getIncomeCnaps() + "|" + amount;
        JDomUtils.addChild((Element)ReqParam, (String)"signDataStr", (String)str);
        String signData = SignUtils.sign(str);
        JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)signData);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)QLBankData, (String)encoding);
        String msg = tr_code + "|#" + xmlMsg;
        return msg;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        String xml = TParser.parseRsp(s, encoding);
        Element QLBankData = JDomUtils.string2Root((String)xml, (String)encoding);
        Element opResult = QLBankData.getChild("opRep").getChild("opResult");
        if (opResult == null) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)"", (String)"");
        } else if (!"".equals(opResult.getChildTextTrim("errorCode"))) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)opResult.getChildTextTrim("errorCode"), (String)opResult.getChildTextTrim("errorMessage"));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE003/CBE004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u666e\u901a\u4ed8\u6b3e:\u884c\u5185\u8f6c\u8d26(CBE003)\uff0c \u8de8\u884c\u8f6c\u8d26 (CBE004)\u3002", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

