/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sde.dc.services.payment.outter;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sde.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.sde.dc.services.payment.outter.OutterQueryPayImpl;
import kd.ebg.aqap.banks.sde.dc.utils.SDEPackerUtils;
import kd.ebg.aqap.banks.sde.dc.utils.SDEParserUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OutterPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(OutterPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OutterQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        String testDate = RequestContextUtils.getBankParameterValue((String)"signDate4Test");
        Element root = SDEPackerUtils.createRootWithHead(Sequence.genSequence(), "B2ECrossBankTransfer");
        Element Body = JDomUtils.addChild((Element)root, (String)"Body");
        String now = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String submitNo = now + paymentInfo.getDetailBizNo().substring(paymentInfo.getDetailBizNo().length() - 8);
        if (!StringUtils.isEmpty((String)testDate)) {
            submitNo = testDate + submitNo.substring(8);
        }
        JDomUtils.addChild((Element)Body, (String)"SubmitNo", (String)submitNo);
        Element List2 = JDomUtils.addChild((Element)Body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)Map2, (String)"TrsPassword", (String)RequestContextUtils.getParameter().getBankParameter("userPassword"));
        JDomUtils.addChild((Element)Map2, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Map2, (String)"PayeeBankId", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)Map2, (String)"PayeeBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)Map2, (String)"UnionDeptId", (String)paymentInfo.getIncomeCnaps());
        String exp = paymentInfo.getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            exp = paymentInfo.getBankDetailSeqId() + "KD@" + paymentInfo.getExplanation();
        }
        JDomUtils.addChild((Element)Map2, (String)"Remark", (String)exp);
        JDomUtils.addChild((Element)Map2, (String)"TransferType", (String)"0");
        JDomUtils.addChild((Element)Map2, (String)"PayeeTel", (String)"");
        JDomUtils.addChild((Element)Map2, (String)"Priority", (String)(paymentInfo.is2Urgent() ? "Y" : "N"));
        return JDomUtils.root2String((Element)root, (String)"GBK");
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        logger.info("\u987a\u5fb7\u519c\u5546\u94f6\u884c\u4ed8\u6b3e\u63a5\u53e3\u54cd\u5e94\u65e5\u5fd7=======>" + responseStr);
        List paymentInfos = request.getPaymentInfos();
        try {
            Element root = SDEParserUtils.parseRspToRoot(responseStr);
            BankResponse response = SDEParserUtils.parseResponse(root);
            if (!"000000".equalsIgnoreCase(response.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u7aef\u652f\u4ed8\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (String)"OutterPayImpl_0", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            } else {
                Element Body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
                Element List2 = JDomUtils.getChildElementNotNull((Element)Body, (String)"List");
                Element Map2 = JDomUtils.getChildElementNotNull((Element)List2, (String)"Map");
                String ReturnCode = JDomUtils.getChildTextNotNull((Element)Map2, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u72b6\u6001\u7801", (String)"OutterPayImpl_1", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
                String ReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Map2, (String)"ReturnMsg");
                if (!"000000".equalsIgnoreCase(ReturnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u7aef\u652f\u4ed8\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (String)"OutterPayImpl_0", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                }
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u6570\u636e\u5f02\u5e38:%1$s\u3002", (String)"OutterPayImpl_4", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"OutterPayImpl_3", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !paymentInfo.is2SameBank();
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml");
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append("B2ECrossBankTransfer").append(".do?");
        sb.append("userPassword=").append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

