/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjrcb.cmp.services;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import kd.ebg.aqap.banks.bjrcb.cmp.utils.MessageUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    public static Element getCommonHead(String trade_code, String file_flag, PaymentInfo paymentInfo) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)trade_code);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no");
        JDomUtils.addChild((Element)head, (String)"user_no");
        JDomUtils.addChild((Element)head, (String)"org_code");
        JDomUtils.addChild((Element)head, (String)"serial_no");
        String serialNo = Sequence.gen18Sequence();
        if (trade_code.equalsIgnoreCase("300001")) {
            serialNo = paymentInfo.getBankBatchSeqID();
        }
        JDomUtils.addChild((Element)head, (String)"req_no", (String)serialNo);
        Date now = new Date();
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)DateUtil.formatDate((Date)now));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)DateUtil.formatTime((Date)now));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign");
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)file_flag);
        JDomUtils.addChild((Element)head, (String)"reserved");
        return head;
    }

    public static Element getCommonHead(String trade_code, String file_flag) {
        return Packer.getCommonHead(trade_code, file_flag, null);
    }

    public static String packSendMsg(String requestStr, String flag) {
        long msgLength;
        StringBuilder returnMsg = new StringBuilder();
        try {
            msgLength = requestStr.getBytes("GB18030").length;
        }
        catch (UnsupportedEncodingException | NullPointerException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        returnMsg.append(MessageUtil.formatNumber(msgLength + 2L)).append(flag).append("0").append(requestStr);
        return returnMsg.toString();
    }
}

