/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.balance;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseAccountMeahisbalqryRequestV1;
import com.icbc.api.response.MybankEnterpriseAccountMeahisbalqryResponseV1;
import java.time.LocalDate;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.balance.BalanceParser;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import net.sf.json.JSONObject;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(HistoryBalanceImpl.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "QHISBAL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u4f59\u989d", (String)"HistoryBalanceImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse hisBalance(BankBalanceRequest rqst) {
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/account/meahisbalqry/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseAccountMeahisbalqryRequestV1.MybankEnterpriseAccountMeahisbalqryRequestBizV1 bizContent = new MybankEnterpriseAccountMeahisbalqryRequestV1.MybankEnterpriseAccountMeahisbalqryRequestBizV1();
            Date date = new Date();
            BankAcnt acnt = rqst.getAcnt();
            bizContent.setTransCode("QHISBAL");
            bizContent.setTranDate(TestDateUtil.getDate());
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            bizContent.setAccountNo(acnt.getAccNo());
            bizContent.setCurrency(rqst.getBankCurrency());
            bizContent.setBeginDate(LocalDateUtil.formatDate((LocalDate)rqst.getStartDate(), (String)"yyyyMMdd"));
            bizContent.setEndDate(LocalDateUtil.formatDate((LocalDate)rqst.getEndDate(), (String)"yyyyMMdd"));
            MybankEnterpriseAccountMeahisbalqryRequestV1 request = new MybankEnterpriseAccountMeahisbalqryRequestV1();
            request.setServiceUrl(BASE_URL + URI);
            request.setBizContent((BizContent)bizContent);
            this.logger.info("\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
            MybankEnterpriseAccountMeahisbalqryResponseV1 response = (MybankEnterpriseAccountMeahisbalqryResponseV1)client.execute((IcbcRequest)request, Sequence.gen18Sequence());
            this.logger.info("\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            return new BalanceParser().parseHisBalanceBalance(rqst, response);
        }
        catch (Exception e) {
            this.logger.error("balance error :", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public LocalDate limitDate() {
        return null;
    }

    public int queryDays() {
        return 30;
    }
}

