/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.payment.allocation;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.request.MybankOspayEnterpriseCapitalpoolMoecfundtransubmitRequestV1;
import com.icbc.api.response.MybankOspayEnterpriseCapitalpoolMoecfundtransubmitResponseV1;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.opa.service.payment.allocation.QGCOLDIS;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.PackerUtils;
import kd.ebg.aqap.banks.icbc.opa.service.util.PayStatus;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;

public class GCOLDIS
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(GCOLDIS.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QGCOLDIS.class;
    }

    public EBBankPayResponse pay(BankPayRequest bankPayRequest) {
        List paymentInfos;
        block8: {
            paymentInfos = bankPayRequest.getPaymentInfos();
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
            String path = "mybank/ospay/enterprise/capitalpool/moecfundtransubmit/V1";
            try {
                MybankOspayEnterpriseCapitalpoolMoecfundtransubmitRequestV1.MybankOspayEnterpriseCapitalpoolMoecfundtransubmitRequestBizV1 bizContent = new MybankOspayEnterpriseCapitalpoolMoecfundtransubmitRequestV1.MybankOspayEnterpriseCapitalpoolMoecfundtransubmitRequestBizV1();
                MybankOspayEnterpriseCapitalpoolMoecfundtransubmitRequestV1 request = new MybankOspayEnterpriseCapitalpoolMoecfundtransubmitRequestV1();
                bizContent.setTransCode(this.getBizCode());
                bizContent.setTranDate(TestDateUtil.getDate());
                bizContent.setTranTime(DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS"));
                bizContent.setfSeqNo(paymentInfo.getBankBatchSeqId());
                if (UseConvertor.isTransUp((PaymentInfo)paymentInfo)) {
                    bizContent.setAllocateType("2");
                    bizContent.setAccountNo(paymentInfo.getIncomeAccNo());
                    bizContent.setMemberAccountNo(paymentInfo.getAccNo());
                } else {
                    bizContent.setAllocateType("4");
                    bizContent.setRealtimeSweep("0");
                    bizContent.setAccountNo(paymentInfo.getAccNo());
                    bizContent.setMemberAccountNo(paymentInfo.getIncomeAccNo());
                }
                bizContent.setAccountNo(paymentInfo.getAccNo());
                bizContent.setCurrency(paymentInfo.getCurrency());
                bizContent.setProtocolNo(BankBusinessConfig.getProtocolNo(paymentInfo.getAccNo()));
                bizContent.setAllocateAmount(PackerUtils.getAmountLong(paymentInfo));
                request.setBizContent((BizContent)bizContent);
                String baseUrl = GetStore.getBaseUrl();
                DefaultIcbcClient client = GetStore.getClient();
                try {
                    MybankOspayEnterpriseCapitalpoolMoecfundtransubmitResponseV1 response = (MybankOspayEnterpriseCapitalpoolMoecfundtransubmitResponseV1)PackerUtils.send(request, baseUrl + path, client);
                    int code = response.getReturnCode();
                    String msg = response.getReturnMsg();
                    if (response.isSuccess()) {
                        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)(code + ""), (String)msg);
                        break block8;
                    }
                    if (PayStatus.INSTANCE.isFail(code)) {
                        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c%s\u3002", (String)"PayParser_4", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), PayStatus.INSTANCE.convertTrans(code)), (String)(code + ""), (String)msg);
                        break block8;
                    }
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)(code + ""), (String)msg);
                }
                catch (Exception e) {
                    String causeMsg = Objects.nonNull(e.getCause()) ? "," + e.getCause().toString() : "";
                    logger.error("\u5212\u62e8\u5f02\u5e38\uff1a{}", new Object[]{causeMsg});
                    EBContext.getContext().setThrowableAfterSend((Throwable)e);
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.payFailException((String)e.getMessage(), (Throwable)e);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GCOLDIS";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

