/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lib.dc.services.payment.batch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lib.dc.services.payment.batch.IESI309011;
import kd.ebg.aqap.banks.lib.dc.services.utils.MessageUtils;
import kd.ebg.aqap.banks.lib.dc.services.utils.Response;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;

public class IESI309009
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IESI309011.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = new JSONObject();
        body.put("batchNo", (Object)info.getBankBatchSeqID());
        body.put("debitAcctNo", (Object)info.getAccNo());
        body.put("debitAcctName", (Object)info.getAccName());
        JSONArray transList = new JSONArray();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (PaymentInfo paymentInfo : paymentInfos) {
            JSONObject tx = new JSONObject();
            tx.put("transId", (Object)paymentInfo.getBankDetailSeqID());
            tx.put("creditAcctNo", (Object)paymentInfo.getIncomeAccNo());
            tx.put("creditAcctName", (Object)paymentInfo.getIncomeAccName());
            tx.put("receiveBankNo", (Object)paymentInfo.getIncomeCnaps());
            tx.put("amount", (Object)paymentInfo.getAmount());
            tx.put("currency", (Object)paymentInfo.getCurrency());
            tx.put("paymentUsage", (Object)paymentInfo.getExplanation());
            tx.put("addtlInf", (Object)paymentInfo.getExplanation());
            String transType = paymentInfo.is2SameBank() ? "0" : (paymentInfo.getAmount().compareTo(new BigDecimal(1000000)) > 0 ? "2" : "1");
            tx.put("transType", (Object)transType);
            totalAmount = totalAmount.add(paymentInfo.getAmount());
            transList.add((Object)tx);
        }
        body.put("transList", (Object)transList);
        body.put("totalNumber", (Object)paymentInfos.size());
        body.put("totalAmount", (Object)totalAmount.setScale(2, RoundingMode.FLOOR));
        return MessageUtils.send(body, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Response response = MessageUtils.receive(s);
        if (response.isSuccess()) {
            JSONObject data = response.getBody();
            int transStatus = data.getIntValue("transStatus");
            if (transStatus >= 0 && transStatus < 3) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)String.valueOf(transStatus), (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)String.valueOf(transStatus), (String)"");
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getRespCode(), (String)response.getRespMsg());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "IESI309009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26", (String)"IESI309009_0", (String)"ebg-aqap-banks-lib-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

