/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynhtb.dc.services.payment.linkpay;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynhtb.dc.services.payment.linkpay.QueryLinkPayImpl;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbPacker;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LinkPayImpl
extends AbstractPayImpl
implements INativeLinkPayable {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryLinkPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = YnhtbPacker.packRoot();
        Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
        Element header = YnhtbPacker.packReqHead("510010", paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)reqData, (Element)header);
        Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
        Boolean sameBank = paymentInfo.getSameBank();
        JDomUtils.addChild((Element)reqParam, (String)"TfrType", (String)(sameBank != false ? "0" : "1"));
        JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)paymentInfo.getThirdAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"AcctName", (String)paymentInfo.getThirdAccName());
        JDomUtils.addChild((Element)reqParam, (String)"SubAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"SubAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)reqParam, (String)"AcctNo1", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"AcctName1", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"BranchNo1", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)reqParam, (String)"BranchName1", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)reqParam, (String)"Ccy", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)reqParam, (String)"Amount", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)reqParam, (String)"CustType", (String)(paymentInfo.is2Individual() ? "0" : "1"));
        JDomUtils.addChild((Element)reqParam, (String)"CertNo", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)reqParam, (String)"Memo", (String)paymentInfo.getExplanation());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        String rspCode = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspCode");
        String rspMsg = JDomUtils.getChildTextTrim((Element)rspHead, (String)"RspMsg");
        if ("000000".equals(rspCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rspCode, (String)rspMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rspCode, (String)rspMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "510010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8", (String)"LinkPayImpl_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

